﻿Imports System.Drawing.Drawing2D
Imports System.Math

Public Class Form1
    Private Sub Form1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        ' Generate star points.
        Dim cx As Integer = Me.ClientSize.Width \ 4
        Dim cy As Integer = Me.ClientSize.Height \ 2
        Dim radius As Integer = CInt(cy * 0.9)
        Dim star_pts(4) As Point
        Dim angle As Double = -PI / 2
        For i As Integer = 0 To 4
            star_pts(i).X = cx + CInt(radius * Cos(angle))
            star_pts(i).Y = cy + CInt(radius * Sin(angle))
            angle += 4 * PI / 5
        Next i

        ' Add the star to the path.
        Using star_path As New GraphicsPath
            star_path.AddPolygon(star_pts)

            ' Make a StringFormat and LayoutRectangle.
            Using string_format As New StringFormat
                string_format.LineAlignment = StringAlignment.Far
                string_format.Alignment = StringAlignment.Center

                Dim layout_rectangle As New RectangleF( _
                    0, 0, Me.ClientSize.Width \ 2, Me.ClientSize.Height)

                e.Graphics.SmoothingMode = SmoothingMode.AntiAlias
                e.Graphics.TextRenderingHint = System.Drawing.Text.TextRenderingHint.AntiAliasGridFit

                ' Draw with FillMode = Alternate.
                star_path.FillMode = FillMode.Alternate

                e.Graphics.DrawString(star_path.FillMode.ToString, _
                    Me.Font, Brushes.Black, _
                    layout_rectangle, string_format)
                e.Graphics.FillPath(Brushes.LightGray, star_path)
                e.Graphics.DrawPath(Pens.Black, star_path)

                ' Move to the right.
                e.Graphics.TranslateTransform(Me.ClientSize.Width \ 2, 0)

                ' Draw with FillMode = Winding.
                star_path.FillMode = FillMode.Winding
                e.Graphics.DrawString(star_path.FillMode.ToString, _
                    Me.Font, Brushes.Black, _
                    layout_rectangle, string_format)
                e.Graphics.FillPath(Brushes.LightGray, star_path)
                e.Graphics.DrawPath(Pens.Black, star_path)
            End Using
        End Using
    End Sub
End Class
