﻿Public Class Form1
    Private all_customers As New List(Of Customer)
    Private all_orders As New List(Of Order)
    Private all_orderitems As New List(Of OrderItem)

    Private Sub Form1_Load() Handles MyBase.Load
        all_customers.Add(New Customer() With {.FirstName = "Alice", .LastName = "Arch", .CustId = 100, .AccountBalance = 10, .PaymentLate = True})
        all_customers.Add(New GoodCustomer() With {.FirstName = "Bob", .LastName = "Bend", .CustId = 200, .AccountBalance = 30, .PaymentLate = True})
        all_customers.Add(New GoodCustomer() With {.FirstName = "Cindy", .LastName = "Cart", .CustId = 300, .AccountBalance = -110, .PaymentLate = True})
        all_customers.Add(New Customer() With {.FirstName = "Dan", .LastName = "Dent", .CustId = 400, .AccountBalance = -95, .PaymentLate = True})

        all_orders.Add(New Order() With {.CustId = 100, .OrderId = 1001, .OrderDate = #4/1/2008#})
        all_orders.Add(New Order() With {.CustId = 100, .OrderId = 1002, .OrderDate = #4/5/2008#})
        all_orders.Add(New Order() With {.CustId = 200, .OrderId = 1003, .OrderDate = #4/12/2008#})
        all_orders.Add(New Order() With {.CustId = 200, .OrderId = 1004, .OrderDate = #4/19/2008#})
        all_orders.Add(New Order() With {.CustId = 300, .OrderId = 1005, .OrderDate = #4/5/2008#})
        all_orders.Add(New Order() With {.CustId = 400, .OrderId = 1006, .OrderDate = #4/19/2008#})
        all_orders.Add(New Order() With {.CustId = 400, .OrderId = 1007, .OrderDate = #4/5/2008#})

        all_orderitems.Add(New OrderItem() With {.OrderId = 1001, .ItemName = "Pencils, dozen", .UnitPrice = 0.75, .Quantity = 3})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1001, .ItemName = "Notepad", .UnitPrice = 1.15, .Quantity = 12})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1001, .ItemName = "Soda, 12-pack", .UnitPrice = 2.75, .Quantity = 4})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1002, .ItemName = "Candy bar", .UnitPrice = 0.65, .Quantity = 144})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1002, .ItemName = "Laptop computer", .UnitPrice = 1445.93, .Quantity = 1})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1003, .ItemName = "Copy paper, ream", .UnitPrice = 2.18, .Quantity = 10})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1004, .ItemName = "Programming book", .UnitPrice = 27.95, .Quantity = 1})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1005, .ItemName = "Pencils, dozen", .UnitPrice = 0.75, .Quantity = 4})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1005, .ItemName = "Dry erase markers, 5-pack", .UnitPrice = 3.8, .Quantity = 2})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1006, .ItemName = "Fancy mouse", .UnitPrice = 42.57, .Quantity = 1})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1007, .ItemName = "12TB flash drive", .UnitPrice = 107.75, .Quantity = 1})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1007, .ItemName = "Pencils, dozen", .UnitPrice = 0.75, .Quantity = 1})

        Dim txt As String = ""

        ' Proste zapytanie.
        Dim q1 = _
            From cust As Customer In all_customers
        txt &= "From" & vbCrLf
        For Each v As Customer In q1
            txt &= Space$(4) & v.ToString() & vbCrLf
        Next v
        txt &= vbCrLf

        ' Proste łączenie.
        Dim q2 = _
            From cust As Customer In all_customers, ord As Order In all_orders _
            Where cust.CustId = ord.CustId
        txt &= "Proste łączenie" & vbCrLf
        For Each v In q2
            txt &= Space$(4) & v.cust.FirstName & ": " & v.ord.OrderId & vbCrLf
        Next v
        txt &= vbCrLf

        ' Join.
        Dim q5 = _
            From cust As Customer In all_customers _
            Join ord As Order In all_orders _
            On cust.CustId Equals ord.CustId
        txt &= "Join" & vbCrLf
        For Each v In q5
            txt &= Space$(4) & v.cust.FirstName & ": " & v.ord.OrderId & vbCrLf
        Next v
        txt &= vbCrLf

        ' Where.
        Dim q3 = _
            From cust In all_customers _
            Where Not (TypeOf cust Is GoodCustomer) _
                  AndAlso cust.PaymentLate _
                  AndAlso OwesALot(cust)
        txt &= "Where" & vbCrLf
        For Each v In q3
            txt &= Space$(4) & v.ToString() & vbCrLf
        Next v
        txt &= vbCrLf

        ' Daty zamówień.
        Dim q4 = _
            From ord In all_orders _
            Where ord.OrderDate > #4/5/2008#
        txt &= "Zamówienia po 4/5/2008" & vbCrLf
        For Each v In q4
            txt &= Space$(4) & v.ToString() & vbCrLf
        Next v
        txt &= vbCrLf

        ' Combined names.
        Dim q6 = From cust In all_customers _
            Select Name = cust.FirstName & " " & cust.LastName, _
                Balance = cust.AccountBalance
        txt &= "Kombinacje nazwisk" & vbCrLf
        For Each v In q6
            txt &= Space$(4) & v.Name & " " & FormatCurrency(v.Balance) & vbCrLf
        Next v
        txt &= vbCrLf

        ' CustInfo.
        Dim q7 = From cust In all_customers _
            Select New CustInfo With { _
                .Name = cust.FirstName & " " & cust.LastName, _
                .Balance = cust.AccountBalance}
        txt &= "CustInfo" & vbCrLf
        For Each ci As CustInfo In q7
            txt &= Space$(4) & ci.Name & " " & FormatCurrency(ci.Balance) & vbCrLf
        Next ci
        txt &= vbCrLf

        ' Konstruktor.
        Dim q8 = From cust In all_customers _
            Select New CustInfo( _
                cust.FirstName & " " & cust.LastName, _
                cust.AccountBalance)
        txt &= "Konstruktor" & vbCrLf
        For Each ci As CustInfo In q8
            txt &= Space$(4) & ci.Name & " " & FormatCurrency(ci.Balance) & vbCrLf
        Next ci
        txt &= vbCrLf

        txtResults.Text = txt
        txtResults.Select(0, 0)
    End Sub

    Private Function OwesALot(ByVal c As Customer) As Boolean
        Return c.AccountBalance <= -50
    End Function
End Class

Public Class Customer
    Public FirstName As String
    Public LastName As String
    Public CustId As Integer
    Public AccountBalance As Decimal
    Public PaymentLate As Boolean
    Public Overrides Function ToString() As String
        Return FirstName & " " & LastName & " - " & CustId & " " & FormatCurrency(AccountBalance)
    End Function
End Class

Public Class GoodCustomer
    Inherits Customer
End Class

Public Class Order
    Public OrderDate As Date
    Public OrderId As Integer
    Public CustId As Integer
    Public Overrides Function ToString() As String
        Return "CustId: " & CustId & ", OrderId: " & OrderId & ", OrderDate: " & OrderDate
    End Function
End Class

Public Class OrderItem
    Public OrderId As Integer
    Public ItemName As String
    Public Quantity As Integer
    Public UnitPrice As Decimal
End Class

Public Class CustInfo
    Public Name As String
    Public Balance As Decimal
    Public Sub New()

    End Sub
    Public Sub New(ByVal new_Name As String, ByVal new_Balance As Decimal)
        Name = new_Name
        Balance = new_Balance
    End Sub
End Class