﻿Option Explicit On
Option Infer On
Option Strict On

Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        ' Tworzenie danych.
        Dim x_all As XElement = _
            <AllCustomers>
                <PositiveBalances>
                    <Customer FirstName="Dan" LastName="Dump">117.95</Customer>
                    <Customer FirstName="Ann" LastName="Archer">100.00</Customer>
                    <Customer FirstName="Carly" LastName="Cant">62.40</Customer>
                </PositiveBalances>
                <NegativeBalances>
                    <Customer FirstName="Ben" LastName="Best">-24.54</Customer>
                    <Customer FirstName="Frank" LastName="Fix">-150.90</Customer>
                    <Customer FirstName="Edna" LastName="Ever">-192.75</Customer>
                </NegativeBalances>
            </AllCustomers>

        Dim txt As String = ""

        txt &= "*** x_all.Descendants(""Customer"")" & vbCrLf
        Dim desc = x_all.Descendants("Customer")
        For Each o In desc
            txt &= o.ToString() & vbCrLf
        Next o
        txt &= vbCrLf

        txt &= "*** x_all...<Customer>" & vbCrLf
        Dim desc2 = x_all...<Customer>
        For Each o In desc2
            txt &= o.ToString() & vbCrLf
        Next o
        txt &= vbCrLf

        txt &= "*** Where cust.@FirstName = ""Ben""" & vbCrLf
        Dim ben = From cust In x_all.Descendants("Customer") _
            Where cust.@FirstName = "Ben"
        For Each o In ben
            txt &= o.ToString() & vbCrLf
        Next o
        txt &= vbCrLf

        txt &= "*** Where cust.@<FirstName> = ""Ann""" & vbCrLf
        Dim ann = From cust In x_all...<Customer> _
            Where cust.@<FirstName> = "Ann"
        For Each o In ann
            txt &= o.ToString() & vbCrLf
        Next o
        txt &= vbCrLf

        txt &= "*** x_all.<NegativeBalances>.Descendants(""Customer"")" & vbCrLf
        Dim neg_desc = From cust In x_all.<NegativeBalances>.Descendants("Customer")
        For Each o In neg_desc
            txt &= o.ToString() & vbCrLf
        Next o
        txt &= vbCrLf

        txt &= "*** x_all.<NegativeBalances>...<Customer> Where CDec(cust.Value) < -50" & vbCrLf
        Dim neg_desc2 = From cust In x_all.<NegativeBalances>...<Customer> _
            Where CDec(cust.Value) < -50
        For Each o In neg_desc2
            txt &= o.ToString() & vbCrLf
        Next o
        txt &= vbCrLf

        txt &= "*** x_all...<PositiveBalances>...<Customer>" & vbCrLf
        Dim pos_cust = From cust In x_all...<PositiveBalances>...<Customer> _
            Select cust.@FirstName, cust.@LastName, cust.Value
        For Each o In pos_cust
            txt &= o.ToString() & vbCrLf
        Next o
        txt &= vbCrLf

        txt &= "*** x_all...<NegativeBalances>.<Customer>(1)" & vbCrLf
        Dim neg_cust1 = x_all...<NegativeBalances>.<Customer>(1)
        txt &= neg_cust1.ToString() & vbCrLf
        txt &= vbCrLf

        txtResults.Text = txt
        txtResults.Select(0, 0)
    End Sub
End Class

Public Class Customer
    Public FirstName As String
    Public LastName As String
    Public Balance As Decimal
    Public Overrides Function ToString() As String
        Return FirstName & " " & LastName & " (" & Balance & ")"
    End Function
End Class
