﻿Imports System.IO

Public Class Form1
    Private m_FileName As String = ""

    ' Załadowanie pliku i ustawienie własności MdiParent formularza.
    Public Sub LoadFile(ByVal file_name As String, ByVal mdi_parent As MDIParent1)
        ' Zapisanie nazwy pliku i MdiParent.
        m_FileName = file_name
        Me.MdiParent = mdi_parent

        ' Załadowanie pliku.
        txtContents.Text = File.ReadAllText(m_FileName)
        txtContents.Select(0, 0)

        ' Wyświetlenie nazwy pliku.
        Me.Text = New FileInfo(m_FileName).Name

        ' Dane nie były modyfikowane od czasu załadowania.
        txtContents.Modified = False
    End Sub

    ' Zamknięcie formularza.
    Private Sub mnuFileClose_Click() Handles mnuFileClose.Click
        Me.Close()
    End Sub

    ' Sprawdzenie czy zamknięcie formularza jest bezpieczne.
    Private Sub mdiChild_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        If txtContents.Modified Then
            ' Są niezapisane zmiany.
            ' Spytanie użytkownika, czy je zapisać.
            Select Case MessageBox.Show( _
                    "Dane zostały zmodyfikowane. Chcesz zapisać zmiany?", _
                    "Zapisać zmiany?", _
                    MessageBoxButtons.YesNoCancel, _
                    MessageBoxIcon.Question)
                Case Windows.Forms.DialogResult.Yes
                    ' Zapisanie zmian.
                    SaveFile()

                    ' Sprawdzenie czy operacja powiodła się.
                    e.Cancel = txtContents.Modified
                Case Windows.Forms.DialogResult.No
                    ' Odrzucenie zmian.
                    ' Pozostawienie e.Cancel = False.
                Case Windows.Forms.DialogResult.Cancel
                    ' Anulowanie zamykania.
                    e.Cancel = True
            End Select
        End If
    End Sub

    ' Zapisanie pliku.
    Private Sub SaveFile()
        File.WriteAllText(m_FileName, txtContents.Text)
        txtContents.Modified = False
        Me.Text = New FileInfo(m_FileName).Name
    End Sub

    ' Zaznaczenie danych jako zmodyfikowane.
    Private Sub txtContents_TextChanged() Handles txtContents.TextChanged
        txtContents.Modified = True
        If Not Me.Text.EndsWith("*") Then
            If m_FileName.Length > 0 Then
                Me.Text = New FileInfo(m_FileName).Name & "*"
            Else
                Me.Text = "*"
            End If
        End If
    End Sub

    ' Zapisanie zmian.
    Private Sub mnuFileSave_Click() Handles mnuFileSave.Click
        SaveFile()
    End Sub
End Class
