Module Module1

    Sub Main()
      Dim doc As New Document("Przykadowy dokument")
      doc.Status = -1
      doc.Read()
      doc.Compress()
      Console.WriteLine("Status dokumentu: {0}", doc.Status)

    End Sub

End Module
Interface IStorable
   Sub Read()
   Sub Write(ByVal obj As Object)
   Property Status() As Integer
End Interface 'IStorable

' nowy interfejs
Interface ICompressible
   Sub Compress()
   Sub Decompress()
End Interface 'ICompressible


' klasa Document implementuje oba interfejsy
Public Class Document
   Implements ICompressible, IStorable

   ' konstruktor klasy Document
   Public Sub New(ByVal s As String)
      Console.WriteLine("Tworzenie dokumentu z: {0}", s)
   End Sub 'New

   ' implementacja interfejsu IStorable
   Public Sub Read() Implements IStorable.Read
      Console.WriteLine("Implementacja metody Read interfejsu IStorable")
   End Sub 'Read


   Public Sub Write(ByVal o As Object) Implements IStorable.Write
      Console.WriteLine( _
        "Implementacja metody Write interfejsu IStorable")
   End Sub 'Write

   Public Property Status() As Integer Implements IStorable.Status
      Get
         Return myStatus
      End Get
      Set(ByVal Value As Integer)
         myStatus = Value
      End Set
   End Property

   ' implementacja interfejsu ICompressible
   Public Sub Compress() Implements ICompressible.Compress
      Console.WriteLine("Implementacja metody Compress")
   End Sub 'Compress

   Public Sub Decompress() Implements ICompressible.Decompress
      Console.WriteLine("Implementacja metody Decompress")
   End Sub 'Decompress

   ' zmienna przechowuje dan dla waciwoci Status interfejsu IStorable
   Private myStatus As Integer = 0
End Class 'Document
