Option Explicit On
Option Strict On

Partial Class ManageRoles_aspx
   Inherits System.Web.UI.Page

   Dim rolesArray As String()
   Dim usersInRole As String()
   Dim users As MembershipUserCollection

   Protected Sub Page_Load( _
   ByVal sender As Object, _
   ByVal e As System.EventArgs) Handles Me.Load
      If User.IsInRole("Manager") = False Then
         Response.Redirect("NoPrivs.aspx")
      End If
      Msg.Text = String.Empty
      If Not IsPostBack Then
         rolesArray = Roles.GetAllRoles()
         RolesListBox.DataSource = rolesArray
         RolesListBox.DataBind()
         users = Membership.GetAllUsers()
         UsersListBox.DataSource = users
         UsersListBox.DataBind()
      End If
      If (RolesListBox.SelectedItem IsNot Nothing) Then
         usersInRole = Roles.GetUsersInRole(RolesListBox.SelectedItem.Value)
         UsersInRoleGrid.DataSource = usersInRole
         UsersInRoleGrid.DataBind()
      End If
   End Sub




   Protected Sub AddUsers_OnClick( _
   ByVal sender As Object, _
   ByVal e As System.EventArgs) Handles btnAddUsersToRole.Click

      '  Naley wybra rol
      If RolesListBox.SelectedItem Is Nothing Then
         Msg.Text = "Prosz wybra rol."
         Exit Sub
      End If

      ' Naley wybra co najmniej jednego uytkownika
      If UsersListBox.SelectedItem Is Nothing Then
         Msg.Text = "Prosz wybra jednego lub wicej uytkownikw."
         Exit Sub
      End If

      ' Utworzenie listy uytkownikw, ktrzy zostan przypisani do wybranej roli
      Dim sizeOfArray As Integer = UsersListBox.GetSelectedIndices.Length
      Dim newUsers(sizeOfArray - 1) As String

      'For i As Integer = 0 To newusers.Length - 1
      '    newusers(i) = _
      '    UsersListBox.Items( _
      '        UsersListBox.GetSelectedIndices()(i)).Value
      'Next

      For i As Integer = 0 To newUsers.Length - 1
         ' odczytanie tablicy wynranych indeksw z listy (wielokrotnego) wyboru
         Dim selectedIndices As Integer() = UsersListBox.GetSelectedIndices()
         ' odczytanie wybranego indeksu selectedIndex odpowiadajcego licznikowi (i)
         Dim selectedIndex As Integer = selectedIndices(i)
         ' odczytanie elementu ListItem z kolekcji UserListBox.Items odpowiadajcemu podanemu przesuniciu
         Dim myListItem As ListItem = UsersListBox.Items(selectedIndex)
         ' odczytanie cigu znakw bdcego wartoci danego elementu ListItem
         Dim newUser As String = myListItem.Value
         ' dodanie odczytanego cigu znakw do kolekcji acuchw znakw newUsers
         newUsers(i) = newUser
      Next


      ' Dodanie uytkownikw do wybranej roli
      Roles.AddUsersToRole(newUsers, RolesListBox.SelectedItem.Value)
      usersInRole = Roles.GetUsersInRole(RolesListBox.SelectedItem.Value)
      UsersInRoleGrid.DataSource = usersInRole
      UsersInRoleGrid.DataBind()

   End Sub



   Protected Sub UsersInRoleGrid_RemoveFromRole( _
   ByVal sender As Object, _
   ByVal e As System.Web.UI.WebControls.GridViewCommandEventArgs) _
   Handles UsersInRoleGrid.RowCommand

      ' odczytanie uytkownika, ktry ma zosta usunity
      Dim index As Integer = Convert.ToInt32(e.CommandArgument)
      Dim username As String = _
      CType(UsersInRoleGrid.Rows(index).Cells(0).Controls(0), _
          DataBoundLiteralControl).Text

      ' usunicie uytkownika
      Roles.RemoveUserFromRole(username, RolesListBox.SelectedItem.Value)

      ' dowizanie uytkownikw posiadajcych rol do siatki Gridview
      usersInRole = Roles.GetUsersInRole(RolesListBox.SelectedItem.Value)
      UsersInRoleGrid.DataSource = usersInRole
      UsersInRoleGrid.DataBind()
   End Sub


   Protected Sub CreateRole_OnClick( _
   ByVal sender As Object, _
   ByVal e As System.EventArgs) Handles btnCreateRole.Click
      pnlCreateRole.Visible = True
   End Sub

   Protected Sub btnAddRole_Click( _
   ByVal sender As Object, _
   ByVal e As System.EventArgs) Handles btnAddRole.Click
      If txtNewRole.Text.Length > 0 Then
         Dim newRole As String = txtNewRole.Text

         ' jeli rola jeszcze nie istnieje, trzeba j doda
         ' dowizanie rl do listy rozwijanej
         If Roles.RoleExists(newRole) = False Then
            Roles.CreateRole(newRole)
            rolesArray = Roles.GetAllRoles()
            RolesListBox.DataSource = rolesArray
            RolesListBox.DataBind()
         End If
      End If
      txtNewRole.Text = String.Empty
      pnlCreateRole.Visible = False
   End Sub
End Class
