Imports System.Web.UI
Partial Class DisplayModeMenu
    Inherits System.Web.UI.UserControl

   Dim myWebPartManager As WebPartManager

   Protected Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init
      AddHandler Page.InitComplete, AddressOf Page_InitComplete
   End Sub

   Protected Sub Page_InitComplete( _
   ByVal sender As Object, _
   ByVal e As System.EventArgs)
      myWebPartManager = _
        WebPartManager.GetCurrentWebPartManager(Page)

      For Each mode As WebPartDisplayMode In _
         myWebPartManager.SupportedDisplayModes
         Dim modeName As String = mode.Name
         If mode.IsEnabled(myWebPartManager) Then
            Dim myListItem As ListItem = _
               New ListItem(modeName, modeName)
            ddlDisplayMode.Items.Add(myListItem)
         End If
      Next
   End Sub




   Protected Sub ddlDisplayMode_SelectedIndexChanged( _
   ByVal sender As Object, _
   ByVal e As System.EventArgs) _
   Handles ddlDisplayMode.SelectedIndexChanged
      Dim selectedMode As String = ddlDisplayMode.SelectedValue
      Dim mode As WebPartDisplayMode = _
      myWebPartManager.SupportedDisplayModes(selectedMode)
      If (mode IsNot Nothing) Then
         myWebPartManager.DisplayMode = mode
      End If
   End Sub



   Protected Sub Page_PreRender( _
   ByVal sender As Object, _
   ByVal e As System.EventArgs) Handles Me.PreRender
      Dim items As ListItemCollection = ddlDisplayMode.Items
      Dim selectedIndex As Integer = _
      items.IndexOf(items.FindByText(myWebPartManager.DisplayMode.Name))
      ddlDisplayMode.SelectedIndex = selectedIndex
   End Sub
End Class
