﻿Imports System.Windows.Forms
Imports System.Runtime.InteropServices
Imports System.ComponentModel

<ToolboxBitmap(GetType(System.Windows.Forms.Button))> _
Public Class CommandLink
    Inherits Button

    'Prywatne zmienne i obiekty.
    Private blnUACShield As Boolean = False
    Private strSupplementalExplanation As String = String.Empty
    Private objBitmap As Bitmap

    'Prywatne stałe.
    Private Const BS_COMMANDLINK As Integer = 14
    Private Const BCM_SETNOTE As Integer = 5641
    Private Const BCM_SETSHIELD As Integer = 5644
    Private Const BM_SETIMAGE As Integer = 247

    'Interfejs API funkcji SendMessage.
    <DllImport("user32.dll", CharSet:=CharSet.Unicode)> _
    Private Shared Function SendMessage(ByVal hWnd As IntPtr, _
        ByVal msg As Integer, ByVal wParam As Integer, _
        ByVal lParam As String) As Integer
    End Function

    <DllImport("user32.dll")> _
    Private Shared Function SendMessage(ByVal hWnd As IntPtr, _
        ByVal msg As Integer, ByVal wParam As Integer, _
        ByVal lParam As Boolean) As Integer
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function SendMessage(ByVal hWnd As IntPtr, _
        ByVal msg As Integer, ByVal wParam As Integer, _
        ByVal lParam As Integer) As Integer
    End Function

    Public Sub New()
        'Ustawianie właściwości FlatStyle.
        Me.FlatStyle = FlatStyle.System
    End Sub

    Protected Overrides ReadOnly Property DefaultSize() _
    As System.Drawing.Size
        Get
            'Ustawia nowy rozmiar domyślny kontrolki
            'umieszczanej na formularzu.
            Return New Size(270, 60)
        End Get
    End Property

    Protected Overrides ReadOnly Property CreateParams() _
    As System.Windows.Forms.CreateParams
        Get
            'Ustawianie stylu przycisku na przycisk typu CommandLink.
            Dim objCreateParams As CreateParams = MyBase.CreateParams
            objCreateParams.Style = objCreateParams.Style Or BS_COMMANDLINK
            Return objCreateParams
        End Get
    End Property

    <Category("Appearance"), _
Description("Powoduje wyświetlenie na kontrolce ikony tarczy " & _
"mechanizmu kontroli konta użytkownika."), _
DefaultValue(False)> _
    Public Property UACShield() As Boolean
        Get
            Return blnUACShield
        End Get
        Set(ByVal value As Boolean)
            blnUACShield = value
            'Dodawanie ikony tarczy do kontrolki.
            SendMessage(Me.Handle, BCM_SETSHIELD, 0, blnUACShield)
        End Set
    End Property

    <Category("Appearance"), _
Description("Opcjonalne pomocnicze wyjaśnienia na temat kontrolki."), _
DefaultValue("")> _
    Public Property SupplementalExplanation() As String
        Get
            Return strSupplementalExplanation
        End Get
        Set(ByVal value As String)
            strSupplementalExplanation = value
            'Dodawanie pomocniczych wyjaśnień do kontrolki.
            SendMessage(Me.Handle, BCM_SETNOTE, 0, value)
        End Set
    End Property

    <Category("Appearance"), _
Description("Rysunek wyświetlany na kontrolce."), _
DefaultValue(GetType(Nullable))> _
    Public Shadows Property Image() As Bitmap
        Get
            Return objBitmap
        End Get
        Set(ByVal value As Bitmap)
            objBitmap = value
            UACShield = False
            If value IsNot Nothing Then
                'Dodawanie rysunku do kontrolki zamiast używania domyślnej ikony.
                SendMessage(Me.Handle, BM_SETIMAGE, 1, objBitmap.GetHicon.ToInt32)
            End If
        End Set
    End Property

End Class

