﻿Imports System.Collections.Generic
Public Class Debug
    'Zmienne klasy Generics.
    Private objStringValues As New Generics(Of String)
    Private objIntegerValues As New Generics(Of Integer)

    'Używanie klasy List(Of T).
    Private objCustomerList As New List(Of Customer)

    Private Sub ListCustomer(ByVal customerToList As Customer)
        lstData.Items.Add(customerToList.CustomerID & _
                "—" & customerToList.CustomerName)
    End Sub

    Private Sub btnStart_Click(ByVal sender As Object, _
       ByVal e As System.EventArgs) Handles btnStart.Click
        'Deklaracja zmiennej.
        Dim strData As String

        lstData.Items.Add("Dane w zmiennej typu String:")
        Try
            If strData.Length > 0 Then
                lstData.Items.Add(strData)
            End If
        Catch NullReferenceExceptionErr As NullReferenceException
            strData = "Ciąg został zainicjowany"
            lstData.Items.Add(strData)
        End Try

        'Dodanie pustego ciągu znaków do kontrolki ListBox.
        lstData.Items.Add(String.Empty)

        'Przykład zastosowania klasy List(Of T).
        lstData.Items.Add("Obiekty klasy Customer:")
        objCustomerList.Add(New Customer(1001, "Henryk Kowa"))
        objCustomerList.Add(New Customer(1002, "Oskar Pisz"))
        For Each objCustomer As Customer In objCustomerList
            ListCustomer(objCustomer)
        Next

        'Dodanie pustego ciągu znaków do kontrolki ListBox.
        lstData.Items.Add(String.Empty)

        'Przykład zastosowania klasy Generics.
        lstData.Items.Add("Pary klucz-wartość " & _
            "klasy Generics - wartości typu String:")
        objStringValues.Add("1001", "Henryk Kowal")
        lstData.Items.Add(objStringValues.Key(0) & " = " & _
            objStringValues.Value(0))

        'Dodanie pustego ciągu znaków do kontrolki ListBox.
        lstData.Items.Add(String.Empty)

        'Przykład zastosowania klasy Generics.
        lstData.Items.Add("Pary klucz-wartość " & _
             "klasy Generics - wartości typu Integer:")
        objIntegerValues.Add("Henryk Kowal", 1001)
        lstData.Items.Add(objIntegerValues.Key(0) & " = " & _
            objIntegerValues.Value(0))

        'Dodanie pustego ciągu znaków do kontrolki ListBox.
        lstData.Items.Add(String.Empty)

        'Przykład zastosowania instrukcji Using.
        'Umożliwia zajęcie, użycie i zwolnienie zasobów.
        lstData.Items.Add("Właściwości klasy Computer:")
        Using objMemory As New Computer
            lstData.Items.Add("FreeMemory = " & objMemory.FreeMemory)
            lstData.Items.Add("TotalMemory = " & objMemory.TotalMemory)
        End Using

        'Dodanie pustego ciągu znaków do kontrolki ListBox.
        lstData.Items.Add(String.Empty)

        'Przykład zastosowania instrukcji Continue.
        Dim strPassword As String = "HShHaslo"
        Dim strLowerCaseLetters As String = String.Empty
        'Pobranie małych liter z ciągu znaków.
        For intIndex As Integer = 0 To strPassword.Length - 1
            'Przykład zastosowania instrukcji Continue.
            'Jeśli znaleziona litera nie jest mała, pętla kontynuuje działanie.
            If Not strPassword.Substring(intIndex, 1) Like "[a-z]" Then
                'Litera nie jest mała — przejście do następnej iteracji pętli.
                Continue For
            End If
            'Znaleziono małą literę — należy ją zapisać.
            strLowerCaseLetters &= strPassword.Substring(intIndex, 1)
        Next

        'Wyświetlenie znalezionych małych liter.
        lstData.Items.Add("Małe litery hasła:")
        lstData.Items.Add(strLowerCaseLetters)
    End Sub

End Class
