﻿Public Class MyNamespace
    'Składowa prywatna.
    Private strApplicationName As String = String.Empty

    'Zdarzenia publiczne.
    Public Event ApplicationCopyrightChanged(ByVal text As String)
    Public Event ScreenBoundsChanged(ByVal bounds As Rectangle)
    Public Event ScreenWorkingAreaChanged(ByVal bounds As Rectangle)


    Private Sub btnApplicationCopyright_Click(ByVal sender As System.Object, _
        ByVal e As System.EventArgs) Handles btnApplicationCopyright.Click

        RaiseEvent ApplicationCopyrightChanged( _
            My.Application.Info.Copyright)

        MessageBox.Show(My.Application.Info.Copyright, _
            strApplicationName)
    End Sub

    Private Sub btnScreenBounds_Click(ByVal sender As Object, _
        ByVal e As System.EventArgs) Handles btnScreenBounds.Click

        RaiseEvent ScreenBoundsChanged(My.Computer.Screen.Bounds)

        MessageBox.Show(My.Computer.Screen.Bounds.ToString, _
            strApplicationName)
    End Sub

    Private Sub btnScreenWorkingArea_Click(ByVal sender As Object, _
        ByVal e As System.EventArgs) Handles btnScreenWorkingArea.Click

        RaiseEvent ScreenWorkingAreaChanged(My.Computer.Screen.WorkingArea)

        MessageBox.Show(My.Computer.Screen.WorkingArea.ToString, _
            strApplicationName)
    End Sub

    Public Property ApplicationName() As String
        Get
            Return strApplicationName
        End Get
        Set(ByVal value As String)
            strApplicationName = value
        End Set
    End Property

    Public Function TaskBarHeight() As Integer
        Return My.Computer.Screen.Bounds.Height - _
            My.Computer.Screen.WorkingArea.Height
    End Function


    Protected Overrides Sub InitLayout()
        MyBase.InitLayout()

        'Czy kontrolka jest w trybie projektowania?
        If DesignMode Then
            lblTime.Text = "Tryb projektowania"
        Else
            Timer1.Enabled = True
        End If
    End Sub


    Private Sub Timer1_Tick(ByVal sender As Object, _
        ByVal e As System.EventArgs) Handles Timer1.Tick

        'Wyświetlanie czasu.
        lblTime.Text = Now.ToLongTimeString

    End Sub
End Class
