﻿'Importowanie przestrzeni nazw Data i SqlClient.
Imports System.Data
Imports System.Data.SqlClient

Public Class Form1
    Dim objConnection As New SqlConnection _
        ("server=localhost\WROX;database=pubs;user id=sa;password=wrox")

    Dim objDataAdapter As New SqlDataAdapter()
    Dim objDataSet As New DataSet()

    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) _
        Handles Me.Load
        'Ustawianie właściwości obiektu SelectCommand.
        objDataAdapter.SelectCommand = New SqlCommand()
        objDataAdapter.SelectCommand.Connection = objConnection
        objDataAdapter.SelectCommand.CommandText = _
            "SELECT au_lname, au_fname, title, price " & _
            "FROM authors " & _
            "JOIN titleauthor ON authors.au_id = titleauthor.au_id " & _
            "JOIN titles ON titleauthor.title_id = titles.title_id " & _
            "ORDER BY au_lname, au_fname"
        objDataAdapter.SelectCommand.CommandType = CommandType.Text

        'Otwieranie połączenia z bazą danych.
        objConnection.Open()

        'Zapełnianie obiektu DataSet danymi.
        objDataAdapter.Fill(objDataSet, "authors")

        'Zamykanie połączenia z bazą danych.
        objConnection.Close()

        'Ustawienie właściwości obiektu DataGridView w celu  
        'powiązania go z danymi.
        grdAuthorTitles.AutoGenerateColumns = True
        grdAuthorTitles.DataSource = objDataSet
        grdAuthorTitles.DataMember = "authors"

        'Deklaracja i ustawienie właściwości opisującej 
        'wyrównanie nagłówka kolumny z ceną.
        Dim objAlignRightCellStyle As New DataGridViewCellStyle
        objAlignRightCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight

        'Deklaracja i ustawienie stylu co drugiego wiersza.
        Dim objAlternatingCellStyle As New DataGridViewCellStyle()
        objAlternatingCellStyle.BackColor = Color.WhiteSmoke
        grdAuthorTitles.AlternatingRowsDefaultCellStyle = objAlternatingCellStyle

        'Deklaracja i ustawienie stylu komórek z cenami książek.
        Dim objCurrencyCellStyle As New DataGridViewCellStyle()
        objCurrencyCellStyle.Format = "c"
        objCurrencyCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight

        'Zmiana nazw i stylów kolumn za pomocą indeksów kolumn.
        grdAuthorTitles.Columns(0).HeaderText = "Imię"
        grdAuthorTitles.Columns(1).HeaderText = "Nazwisko"
        grdAuthorTitles.Columns(2).HeaderText = "Tytuł książki"
        grdAuthorTitles.Columns(2).Width = 225

        'Zmiana nazw i stylów kolumn za pomocą nazw kolumn.
        grdAuthorTitles.Columns("price").HeaderCell.Value = "Cena sprzedaży"
        grdAuthorTitles.Columns("price").HeaderCell.Style = objAlignRightCellStyle
        grdAuthorTitles.Columns("price").DefaultCellStyle = objCurrencyCellStyle

        'Operacje porządkujące.
        objDataAdapter = Nothing
        objConnection = Nothing
        objCurrencyCellStyle = Nothing
        objAlternatingCellStyle = Nothing
        objAlignRightCellStyle = Nothing

    End Sub

End Class
