﻿using UnityEngine;
using System.Linq;

public class FindEnemyTarget : MonoBehaviour
{
    public string FollowTag;
    private FollowTarget _followComp;
    private float _timer;
    private const float FIND_TARGET_TIME = 0.33f;
    void Start()
    {
        _followComp = GetComponent<FollowTarget>();
        _timer = FIND_TARGET_TIME;
    }
    void Update()
    {
        if(_timer > 0)
        {
            _timer -= Time.deltaTime;
            if(_timer < 0)
            {
                _timer = FIND_TARGET_TIME;
                if(_followComp != null && _followComp.target == null)
                {
                    GameObject []enemies = GameObject.FindGameObjectsWithTag(FollowTag);
                    if (enemies.Length > 0)
                    {
                        enemies = enemies.OrderBy((d) => (d.transform.position - transform.position).sqrMagnitude).ToArray();
                        _followComp.target = enemies[0].transform;
                    }
                    else if (_followComp.GetComponent<AutoMove>() != null)
                        _followComp.GetComponent<AutoMove>().enabled = true;
                }
            }
        }
    }
}
