using UnityEngine;

[AddComponentMenu("Playground/Actions/PlayAudio")]
public class AudioAction : Action
{

    public AudioSource Source;
    public AudioClip SoundClip;


    public override bool ExecuteAction(GameObject dataObject)
    {
        if (Source != null && SoundClip != null)
        {
            Source.loop = false;
            Source.clip = SoundClip;
            Source.Play();
            return true;
        }
        else
        {
            Debug.LogWarning("Source or SoundClip is not found. The action can't execute!");
            return false;
        }
    }



}
