﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEditor;

[CanEditMultipleObjects]
[CustomEditor(typeof(ConditionDestroy))]
public class ConditionDestroyInspector : ConditionInspectorBase
{
	private string explanation = "Use this script to perform an action when this GameObject is destroyed.";

	public override void OnInspectorGUI()
	{
		serializedObject.Update();

		GUILayout.Space(10);
		EditorGUILayout.HelpBox(explanation, MessageType.Info);

		GUILayout.Space(10);

		DrawActionLists();

		serializedObject.ApplyModifiedProperties();
	}
}
