﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Doniczka : MonoBehaviour {

    private void OnCollisionEnter(Collision collision)
    {
        Gracz obiektGracz = collision.collider.GetComponent<Gracz>();
        // uwaga! sprawdzamy, czy gracz cokolwiek niesie, aby próba wejścia na doniczkę bez sadzonki nie spowodowała błędu
        if (obiektGracz.NiesionaSadzonka != null)
        {
            
            Sadzonka doZasadzeniaSadzonka = obiektGracz.NiesionaSadzonka;
            GameObject doZasadzeniaRoslina = doZasadzeniaSadzonka.Roslina;
            // włączamy roślinę
            Transform transformRosliny = doZasadzeniaRoslina.GetComponent<Transform>();
            // GetComponentInChildren<Renderer>() szuka komponentu Renderer w podobiektach tego obiektu;
            // szukamy renderera obiektu o nazwie RoslinaX_Obiekt
            Renderer rendererRosliny = transformRosliny.GetComponentInChildren<Renderer>();
            rendererRosliny.enabled = true;

            // przemieszczamy roślinę, aby znalazła się w doniczce
            Transform transformDoniczki = GetComponent<Transform>();
            Vector3 pozycja = transformRosliny.position;
            pozycja.x = transformDoniczki.position.x;
            pozycja.y = transformDoniczki.position.y;
            pozycja.z = transformDoniczki.position.z;
            transformRosliny.position = pozycja;
            // powiadamiamy obiekt gracza, że została posadzona roślina
            obiektGracz.PosadzonoRosline();
        }
        else
            Debug.Log("Gracz nie ma sadzonki.");

    }
}
