﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Doniczka : MonoBehaviour {

    public Sadzonka posadzonaSadzonka;

	// Use this for initialization
	void Start () {
        posadzonaSadzonka = null;

    }
	
    private void OnCollisionEnter(Collision collision)
    {
        Gracz obiektGracz = collision.collider.GetComponent<Gracz>();

        // sprawdzamy, czy gracz próbuje podlać sadzonkę w doniczce 
        if (posadzonaSadzonka != null && obiektGracz.NiesionaKonewka)
        {
            posadzonaSadzonka.Podlej();
            if (posadzonaSadzonka.CzyMogeJuzWyrosnac())
                NiechWyrosnieDrzewo(obiektGracz);
            obiektGracz.NiesionaKonewka = false;
        }
        // sprawdzamy, czy gracz niesie sadzonkę do posadzenia;
        // uwaga: gracz może posadzić sadzonkę na miejscu innej sadzonki — przegra wtedy grę
        else if (obiektGracz.NiesionaSadzonka != null)
        {
            posadzonaSadzonka = obiektGracz.NiesionaSadzonka;
            // przenosimy sadzonkę w nowe miejsce
            posadzonaSadzonka.PrzeniesSadzonke(GetComponent<Transform>());
            posadzonaSadzonka.GraczNiesieSadzonke(obiektGracz, false);
            Transform transformDoniczki = GetComponent<Transform>();
            obiektGracz.PosadzonoSadzonke();
        }
        else
            Debug.Log("Gracz nie ma sadzonki.");

    }

    // gdy wszystkie warunki zostaną spełnione, wywołamy tę funkcję, aby wyrosło drzewo;
    // w projekcie 1. ten kod znajdował się w funkcji OnCollisionEnter,
    // ale gdy rozmiar kodu pojedynczej funkcji rośnie, dla czytelności warto go podzielić
    public void NiechWyrosnieDrzewo(Gracz obiektGracz)
    {
        GameObject doZasadzeniaRoslina = posadzonaSadzonka.Roslina;
        // włączamy roślinę
        Transform transformRosliny = doZasadzeniaRoslina.GetComponent<Transform>();
        // GetComponentInChildren<Renderer>() szuka komponentu Renderer w podobiektach tego obiektu;
        // szukamy renderera obiektu o nazwie RoslinaX_Obiekt
        Renderer rendererRosliny = transformRosliny.GetComponentInChildren<Renderer>();
        rendererRosliny.enabled = true;
        // przemieszczamy roślinę, aby znajdowała się w doniczce
        Transform transformDoniczki = GetComponent<Transform>();
        Vector3 pozycja = transformRosliny.position;
        pozycja.x = transformDoniczki.position.x;
        pozycja.y = transformDoniczki.position.y;
        pozycja.z = transformDoniczki.position.z;
        transformRosliny.position = pozycja;
        // wyłączamy sadzonkę w doniczce
        posadzonaSadzonka.WlaczRenderer(false);
        // powiadamiamy obiekt gracza, że została posadzona roślina
        obiektGracz.WyrosloDrzewo();
        // rośnie już drzewo, a nie sadzonka
        posadzonaSadzonka = null;
    }
}
