﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Sadzonka : MonoBehaviour {

    public GameObject Roslina;
    public int IlePodlanAbyWyrosl;
    private int IleJuzRazyPodlano;
   

	// Use this for initialization
	void Start () {
        // sprawdzamy, czy na pewno w edytorze zostało ustawione pole Roslina
        if (Roslina == null)
            Debug.LogError("Brak ustawienia pola Roslina! ");
        // na starcie dorosła roślina ma zniknąć
        Transform transformRosliny = Roslina.GetComponent<Transform>();
        // GetComponentInChildren<Renderer>() szuka komponentu Renderer w podobiektach tego obiektu;
        // szukamy renderera obiektu o nazwie RoslinaX_Obiekt
        Renderer rendererRosliny = transformRosliny.GetComponentInChildren<Renderer>();
        rendererRosliny.enabled = false;
        IleJuzRazyPodlano = 0;

    }

    private void OnCollisionEnter(Collision collision)
    {
        Gracz obiektGracz = collision.collider.GetComponent<Gracz>();
        if (obiektGracz.NiesionaSadzonka == null)
        { 
            obiektGracz.NiesionaSadzonka = this;
            // wyłączamy wykrywanie kolizji dla obiektu sadzonki 
            GraczNiesieSadzonke(obiektGracz, true);
            WlaczCollider(false);
        }
    }

    public void WlaczCollider(bool CzyWlaczyc)
    {
        Collider ColliderSadzonki = GetComponentInChildren<Collider>();
        ColliderSadzonki.enabled = CzyWlaczyc;
    }
    public void WlaczRenderer(bool CzyWlaczyc)
    {
        Renderer RendererSadzonki = GetComponentInChildren<Renderer>();
        RendererSadzonki.enabled = CzyWlaczyc;
    }

    public void GraczNiesieSadzonke(Gracz obiektGracz, bool CzyNiesie)
    {
        Transform naszTransform = GetComponent<Transform>();
        if (CzyNiesie)
        {
            naszTransform.parent = obiektGracz.pozycjaSadzonki.GetComponent<Transform>();
            PrzeniesSadzonke(obiektGracz.pozycjaSadzonki.GetComponent<Transform>());
        }
        else
        {
            naszTransform.parent = null;
        }
    }

    public void PrzeniesSadzonke(Transform noweMiejsce)
    {
        Transform naszTransform = GetComponent<Transform>();
        Vector3 pozycja = naszTransform.position;
        pozycja.x = noweMiejsce.position.x;
        pozycja.y = noweMiejsce.position.y;
        pozycja.z = noweMiejsce.position.z;
        naszTransform.position = pozycja;
    }

    public void Podlej()
    {
        IleJuzRazyPodlano++;
    }
    public bool CzyMogeJuzWyrosnac()
    {
        return IleJuzRazyPodlano >= IlePodlanAbyWyrosl;
    }
}
