﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Pojemnik : MonoBehaviour {

    public int Maximum;
    public int StanAktualny;
    // tutaj przechowujemy materiały szkła, aby je zamieniać, gdy gracz włączy lub wyłączy zaznaczenie
    public Material Jasne_Szklo;
    public Material Czerwone_Szklo;

    // tutaj przechowujemy obiekt gry będący płynem, tak aby nie trzeba było wielokrotnie go pobierać
    private GameObject naszPlyn;
    
    // Use this for initialization
    void Start () {
        // na początku aktualizujemy rozmiar pojemnika w stosunku do Maximum ustawionego w edytorze; 
        // uwaga: nie można w trakcie gry zmieniać Maximum — nie jest to obsługiwane ani sprawdzane
        Transform naszTransform = GetComponent<Transform>();
        Vector3 naszaSkala = naszTransform.localScale;
        if (Maximum == 8)
            naszaSkala.y = 1f;
        if (Maximum == 5)
            naszaSkala.y = 0.625f;
        if (Maximum == 3)
            naszaSkala.y = 0.375f;
        naszTransform.localScale = naszaSkala;

        // oprócz skali musimy zmodyfikować pozycję, tak aby naczynia nie wisiały w powietrzu,
        // gdy skala ścieśnia je względem połowy wysokości
        Vector3 naszaPozycja = naszTransform.localPosition;
        naszaPozycja.y = naszaSkala.y - 1f;
        naszTransform.localPosition = naszaPozycja;

        // zapamiętamy jeszcze obiekt będący płynem, po to aby móc używać go wielokrotnie bez pobierania;
        // GetChild pobiera kolejny podobiekt w hierarchii; podajemy 0, bo chcemy obiektu pierwszego
        // (a wiemy z edytora, że jest tylko jeden obiekt  — w większych projektach należy sprawdzać takie warunki!);
        // tym, co zwraca GetChild, jest komponent Transform;
        // możemy otrzymać ogólny obiekt — GameObject, odczytując jego pole gameObject
        naszPlyn = naszTransform.GetChild(0).gameObject;       
       
    }
	
	// Update is called once per frame
	void Update () {
		
	}

    private void OnCollisionEnter(Collision collision)
    {
        // w pojemnik mógł uderzyć tylko obiekt RigidBodyFPSController z komponentem KomponentGracza,
        // a więc go pobieramy; w dużych projektach należy sprawdzać, czy takie warunki są prawdziwe
        KomponentGracza Gracz = collision.collider.GetComponent<KomponentGracza>();
        // dalszy przebieg zależy od tego, czy gracz już wcześniej miał wybrany pojemnik, czy nie
        if (Gracz.WybranyPojemnik == null)
        {
            // nie miał — wybieramy pojemnik i zmieniamy jego materiał na czerwone szkło;
            // pole this dotyczy pojemnika, do którego przypisany jest ten skrypt — przypisujemy pojemnik do wybranego pojemnika
            Gracz.WybranyPojemnik = this;   
            Renderer naszRenderer = GetComponent<Renderer>();
            naszRenderer.material = Czerwone_Szklo;
        }
        else
        {
            // najpierw sprawdzamy, czy gracz nie próbuje zaznaczyć już zaznaczonego pojemnika
            // — w takim przypadku nic nie robimy, a zaznaczenie anuluje się dalej po warunku
            if (Gracz.WybranyPojemnik != this)
            {
                // przelewamy z Gracz.WybranyPojemnik do this;
                // dla czytelności zapisujemy pojemniki pod nowymi nazwami
                Pojemnik PierwszyPojemnik = Gracz.WybranyPojemnik;
                Pojemnik DrugiPojemnik = this;
                // realizujemy algorytm przelewania
                if (DrugiPojemnik.Maximum >= PierwszyPojemnik.StanAktualny + DrugiPojemnik.StanAktualny)
                {
                    DrugiPojemnik.StanAktualny = PierwszyPojemnik.StanAktualny + DrugiPojemnik.StanAktualny;
                    PierwszyPojemnik.StanAktualny = 0;
                } else
                {
                    PierwszyPojemnik.StanAktualny = PierwszyPojemnik.StanAktualny - (DrugiPojemnik.Maximum - DrugiPojemnik.StanAktualny);
                    DrugiPojemnik.StanAktualny = DrugiPojemnik.Maximum;                    
                }
                
                PierwszyPojemnik.AktualizujPlyn();
                DrugiPojemnik.AktualizujPlyn();

            }
            AnulujZaznaczenie(Gracz);
        }
       
    }
    
    private void AnulujZaznaczenie(KomponentGracza Gracz)
    {
        if (Gracz.WybranyPojemnik != null)
        {
            Renderer rendererZaznaczonego = Gracz.WybranyPojemnik.GetComponent<Renderer>();
            rendererZaznaczonego.material = Jasne_Szklo;
        }
        Gracz.WybranyPojemnik = null;
    }
    private void AktualizujPlyn()
    {
        // procedura aktualizacji stanu płynu jest podobna do aktualizacji rozmiaru pojemnika w funkcji Start
        Transform TransformPlynu = naszPlyn.GetComponent<Transform>();
        Vector3 SkalaPlynu = TransformPlynu.localScale;
        // obliczenie skali jako stosunku poziomu aktualnego do maksymalnego
        SkalaPlynu.y = (float) StanAktualny / (float) Maximum;      
        TransformPlynu.localScale = SkalaPlynu;
        Vector3 PozycjaPlynu = TransformPlynu.localPosition;
        PozycjaPlynu.y = SkalaPlynu.y - 1f;
        TransformPlynu.localPosition = PozycjaPlynu;
    }
}
