﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SmoothFollow : MonoBehaviour
{

	// Obiekt docelowy, za którym podąża kamera
	public Transform target;

	// Wysokość kamery nad obiektem docelowym
	public float height = 5.0f;

	// Odległość kamery od obiektu docelowego, bez uwzględniania wysokości
	public float distance = 10.0f;

	// O ile wolniejsze będą zmiany obrotu i wysokości
	public float rotationDamping;
	public float heightDamping;

	// Funkcja aktualizująca jest wywoływana podczas generowania każdej klatki
	void LateUpdate()
	{
		// Przerywamy jeśli nie ma obiektu docelowego
		if (!target)
			return;

		// Wyznaczamy aktualne konty obrotu
		var wantedRotationAngle = target.eulerAngles.y;
		var wantedHeight = target.position.y + height;

		// Zapisujemy aktualne położenie i kierunek kamery
		var currentRotationAngle = transform.eulerAngles.y;
		var currentHeight = transform.position.y;

		// Tłumimy kąt obrotu względem osi Y
		currentRotationAngle = Mathf.LerpAngle(currentRotationAngle, 
			wantedRotationAngle, rotationDamping * Time.deltaTime);

		// Tłumimy wysokość
		currentHeight = Mathf.Lerp(currentHeight, 
			wantedHeight, heightDamping * Time.deltaTime);

		// Przekształcamy kąt na obrót
		var currentRotation = Quaternion.Euler(0, currentRotationAngle, 0);

		// Ustawiamy położenie kamery na płaszczyźnie X-Z na 
		// liczbę metrów określoną zmienną "distance"
		transform.position = target.position;
		transform.position -= currentRotation * Vector3.forward * distance;

		// Ustawiamy położenie kamery używając nowej wysokości
		transform.position = new Vector3(transform.position.x, 
			currentHeight, transform.position.z);

		// I w końcu, ustawiamy kamerę w tym samym kierunku w którym patrzy 
		// obiekt docelowy
		transform.rotation = Quaternion.Lerp(transform.rotation, 
			target.rotation, rotationDamping * Time.deltaTime);

	}
}
