﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ShipWeapons : MonoBehaviour {

	// Prefabrykat każdego ze strzałów
	public GameObject shotPrefab;

	public void Awake() {
		// W momencie uruchamiania tego obiektu, informujemy 
		// obiekt InputManager, że będzie to bieżący obiekt uzbrojenia
		InputManager.instance.SetWeapons(this);
	}

	// Ta metoda jest wywoływana podczas usuwania obiektu
	public void OnDestroy() {
		// Nic nie robimy, jeśli nie jesteśmy w trakcie gry
		if (Application.isPlaying == true) {
			InputManager.instance.RemoveWeapons(this);
		}
	}

	// Lista miejsc, w których mogą się pojawiać strzały
	public Transform[] firePoints;

	// Indeks elementu tablicy firePoints, który określi początkowe
	// położenie następnego strzału
	private int firePointIndex;

	// Metoda wywoływana przez skrypt InputManager
	public void Fire() {

		// Jeśli nie ma punktów w których mogą pojawiać się strzały, to kończymy
		if (firePoints.Length == 0) 
			return;

		// Określamy punkt, w którym ma się pojawić strzał
		var firePointToUse = firePoints[firePointIndex];

		// Tworzymy nowy strzał, umieszczamy go w odpowiednim miejscu
		// i określamy rotację
		Instantiate(shotPrefab, 
			firePointToUse.position, 
			firePointToUse.rotation);

		// Przechodzimy do następnego punktu ogniowego
		firePointIndex++;

		// Jeśli przekroczyliśmy zakres tablicy punktów ogniowych,
		// to wracamy na jej początek
		if (firePointIndex >= firePoints.Length)
			firePointIndex = 0;

	}

}
