﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ShipSteering : MonoBehaviour {

	// Szybkość obrotu statku
	public float turnRate = 6.0f;

	// Siła z jaką statek się podnosi
	public float levelDamping = 1.0f;

	void Update () {

		// Tworzymy nową wartość obrotu, mnożąc kierunek wskazywany przez
		// joystic razy szybkość skręcania i ograniczając ją do 90% 
		// połowy okręgu

		// W pierwszej kolejności pobieramy dane wejściowe
		var steeringInput = InputManager.instance.steering.delta;

		// Teraz tworzymy wartość obrotu, jako wektor
		var rotation = new Vector2();

		rotation.y = steeringInput.x;
		rotation.x = steeringInput.y;

		// Mnożymy obrót by uzyskać wartość przesunięcia
		rotation *= turnRate;

		// Przekształcamy wynik na radiany mnożąc przez 90% liczby PI.
		rotation.x = Mathf.Clamp(rotation.x, -Mathf.PI * 0.9f, Mathf.PI * 0.9f);

		// Po czym przekształcamy te wartości w radianach na kwaternion obrotu!
		var newOrientation = Quaternion.Euler(rotation);

		// Łączymy ten obrót z aktualną orientacją
		transform.rotation *= newOrientation;

		// I w końcu próbujemy zmniejszyć pochylenie statku!

		// Zaczynamy od określenia jaka byłaby orientacja statku gdyby w ogóle
		// nie był on obrócony względem osi Z
		var levelAngles = transform.eulerAngles;
		levelAngles.z = 0.0f;
		var levelOrientation = Quaternion.Euler(levelAngles);

		// A następnie łączymy bieżącą orientację z niewielką cząstką
		// "orientacji bez przechylenia"; jeśli tę operację będziemy 
		// sukcesywnie wykonywać w kolejnych klatkach, obiekt powoli 
		// zostanie wyrównany do poziomu
		transform.rotation = Quaternion.Slerp(transform.rotation, 
			levelOrientation, levelDamping * Time.deltaTime);

	}
}
