﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class DamageOnCollide : MonoBehaviour {

	// Liczba uszkodzeń zadawanych innemu obiektowi w efekcie zderzenia
	public int damage = 1;

	// Liczba uszkodzeń jakie podczas zderzenia zostaną zadane temu obiektowi
	public int damageToSelf = 5;

	void HitObject(GameObject theObject) {
		// Zadajemy uszkodzenia obiektowi z którym się zderzyliśmy, o ile to możliwe
		var theirDamage = theObject.GetComponentInParent<DamageTaking>();
		if (theirDamage) {
			theirDamage.TakeDamage(damage);
		}

		// Zadajemy uszkodzenia temu obiektowi, o ile to możliwe
		var ourDamage = this.GetComponentInParent<DamageTaking>();
		if (ourDamage) {
			ourDamage.TakeDamage(damageToSelf);
		}
	}

	// Czy obiekt znalazł się w tym obszarze wyzwalacza?
	void OnTriggerEnter(Collider collider) {
		HitObject(collider.gameObject);
	}

	// Czy inny obiekt zderzył się z tym obiektem?
	void OnCollisionEnter(Collision collision) {    
		HitObject(collision.gameObject);
	}
}
