﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Events;

// Zawiera zdarzenie Unity, UnityEvent, którego można użyć do
// przywrócenia stanu początkowego tego obiektu
public class Resettable : MonoBehaviour {

	// W edytorze Unity należy połączyć to zdarzenie z metodą, którą 
	// należy wykonać w momencie przywracania stanu początkowego gry
	public UnityEvent onReset;

	// Metoda wywoływana przez obiekt GameManager w momencie 
	// przywracania początkowego stanu gry
	public void Reset() {
		// Generujemy zdarzenie, które wywoła wszystkie powiązane metody
		onReset.Invoke();
	}
}
