﻿using UnityEngine;
using System.Collections;

// Zapewnia dostęp do interfejsów Event
using UnityEngine.EventSystems;

// Zapewnia dostęp do elementów interfejsu użytkownika
using UnityEngine.UI;

public class VirtualJoystick : MonoBehaviour, IBeginDragHandler, 
IDragHandler, IEndDragHandler { 

	// Przeciągany sprajt
	public RectTransform thumb;

	// Położenia suwaka oraz joysticka kiedy suwak nie jest przeciągany
	private Vector2 originalPosition;
	private Vector2 originalThumbPosition;

	// Odległość na jaką suwak został przeciągnięty od swego domyślnego położenia
	public Vector2 delta;

	void Start () {
		// Kiedy joystick zaczyna działać, zapisujemy początkowe położenie
		// jego samego oraz jego suwaka
		originalPosition = this.GetComponent<RectTransform>().localPosition;
		originalThumbPosition = thumb.localPosition;

		// Dezaktywujemy suwak, tak by był niewidoczny
		thumb.gameObject.SetActive(false);

		// Ustawiamy odległość na 0
		delta = Vector2.zero;
	}

	// Metoda wywoływana w momencie rozpoczynania przeciągania suwaka
	public void OnBeginDrag (PointerEventData eventData) {

		// Wyświetlamy suwak
		thumb.gameObject.SetActive(true);

		// Określenie punktu, w świecie gry, w którym rozpoczęto przeciąganie
		Vector3 worldPoint = new Vector3();
		RectTransformUtility.ScreenPointToWorldPointInRectangle(
			this.transform as RectTransform, 
			eventData.position, 
			eventData.enterEventCamera, 
			out worldPoint);


		// Umieszczamy joystick w tym miejscu
		this.GetComponent<RectTransform>().position = worldPoint;

		// Zapewniamy, że suwak znajdzie się w jego początkowym położeniu 
		// względem joysticka
		thumb.localPosition = originalThumbPosition;
	}

	// Metoda wywoływana podczas przeciągania
	public void OnDrag (PointerEventData eventData) {

		// Określamy położenie puktu końcowego przeciągnięcia w świecie gry
		Vector3 worldPoint = new Vector3();
		RectTransformUtility.ScreenPointToWorldPointInRectangle(
			this.transform as RectTransform, 
			eventData.position, 
			eventData.enterEventCamera, 
			out worldPoint);

		// Umieszczamy suwaka w tym miejscu
		thumb.position = worldPoint;


		// Obliczamy odległość pomiędzy aktualnym i początkowym położeniem suwaka
		var size = GetComponent<RectTransform>().rect.size;

		delta = thumb.localPosition;

		delta.x /= size.x / 2.0f;
		delta.y /= size.y / 2.0f;

		delta.x = Mathf.Clamp(delta.x, -1.0f, 1.0f);
		delta.y = Mathf.Clamp(delta.y, -1.0f, 1.0f);


	}

	// Metoda wywoływana w momencie zakończenia przeciągania
	public void OnEndDrag (PointerEventData eventData) {
		// Zerujemy położenie joysticka
		this.GetComponent<RectTransform>().localPosition = originalPosition;

		// Zerujemy odległość
		delta = Vector2.zero;

		// Ukrywamy suwak
		thumb.gameObject.SetActive(false);
	}
}

