﻿using UnityEngine;
using UnityEngine.UI;

public class IndicatorManager : Singleton<IndicatorManager> {

	// Obiekt nadrzędny wszystkich obiektów wskaźników
	public RectTransform labelContainer;

	// Prefabrykat, który będzie używany do tworzenia wskaźników
	public Indicator indicatorPrefab;

	// Ta metoda będzie wywoływana przez inne obiekty
	public Indicator AddIndicator(GameObject target, Color color, 
		Sprite sprite = null) {

		// Tworzymy obiekt etykiety
		var newIndicator = Instantiate(indicatorPrefab);

		// Określamy śledzony obiekt
		newIndicator.target = target.transform;

		// Aktualizujemy kolor
		newIndicator.color = color;

		// Jeśli jest określony sprajt, to używamy go także jako sprajta wskaźnika
		if (sprite != null) {
			newIndicator.GetComponent<Image>().sprite = sprite;
		}

		// Dodajemy wskaźnik do pojemnika
		newIndicator.transform.SetParent(labelContainer, false);

		return newIndicator;
	} 
}
