﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using System;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

namespace ZielarzSilnik
{
    public class UIInformacyjne : MonoBehaviour
    {
        public Text TekstOpisu;
        public Canvas Kanwa;
        private const float CZESTOTLIWOSCSPRAWDZANODLEGLOSCI = 0.5f;
        private float _licznikSekund;
        private void Awake()
        {
            Kanwa.gameObject.SetActive(false);
        }
      
        public void Uaktywnij()
        {
            float reputacja = MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.PobierzAtrybut("Reputacja");
            TekstOpisu.text = TlumaczCiagow.PodajCiag("Reputacja_Ogolnie");
            if (reputacja < 0.25)
                TekstOpisu.text += TlumaczCiagow.PodajCiag("Reputacja_1");
            else
                if (reputacja < 0.5)
                    TekstOpisu.text += TlumaczCiagow.PodajCiag("Reputacja_2");
            else
                if (reputacja < 0.75)
                    TekstOpisu.text += TlumaczCiagow.PodajCiag("Reputacja_3");
            else
                if (reputacja < 1)
                    TekstOpisu.text += TlumaczCiagow.PodajCiag("Reputacja_4");
            else
                if (reputacja < 1.33)
                    TekstOpisu.text += TlumaczCiagow.PodajCiag("Reputacja_5");
            else
                TekstOpisu.text += TlumaczCiagow.PodajCiag("Reputacja_6");
            Kanwa.gameObject.SetActive(true);
        }
        void Update()
        {
            if (Kanwa.gameObject.activeInHierarchy)
            {
                _licznikSekund -= Time.deltaTime;
                if (_licznikSekund < 0)
                {
                    _licznikSekund = CZESTOTLIWOSCSPRAWDZANODLEGLOSCI;
                    if ((MenedzerGry.InstancjaMenedzeraGry.KontrolerGracza.transform.position - transform.position).magnitude > MenedzerUI.DYSTANSPOKAZYWANIAKANWY)
                    {
                        Kanwa.gameObject.SetActive(false);
                    }
                }
            }
        }
        private void Start()
        {
            if (TekstOpisu == null)
                Debug.LogError("Nie ustawiono pola TekstOpisu");
            if (Kanwa == null)
                Debug.LogError("Nie ustawiono pola Kanwa");
            _licznikSekund = 0;
        }
    }
}
