﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author


namespace ZielarzSilnik
{

    public class KonfiguratorGry
    {
        /***** Sekcja Gracza *****/
        //receptury znane graczowi na starcie gry
        public static string[] ZnaneRecepturyGracza = { "RecepturaZupaPomidorowa" };
        //podatek dochodowy pobierany o polnocy [% dobowego zysku zlota]
        public static float PodatekDochodowyGracza = 0.18f;
        //koszt złota pobierany o 6 rano
        public static float KosztUtrzymaniaGracza = 90;
        //złoto na starcie gry
        public static float PoczatkoweZlotoGracza = 150;
        //minimalny poziom reputacji, poniżej tego poziomu gracz przegrywa - zostaje wygnany
        public static float GranicaReputacjiGracza = 0.1f;
        //Honorarium zielarza za leczenie szpitalne
        public static int HonorariumZaLeczenieSzpitalne = 50;
        //Honorarium zielarza za skuteczne wyleczenie pacjenta
        public static int HonorariumZaWyleczenie = 20;
        //Zysk reputacji za skuteczne wyleczenie pacjenta
        public static float ReputacjaZaWyleczenie = 1.08f;
        //Utrata reputacji za śmierć pacjenta
        public static float ReputacjaZaSmierc = 0.90f;
        //Utrata reputacji za sytuację w której pacjent, który odszedł od drzwi nie wyleczył się ani nie umarł w ciągu doby
        public static float ReputacjaZaChorobe = 0.99f;

        /***** Sekcja Handlarza *****/
        //optymalna ilość złota handlarza
        public static int OptimumZlotaHandlarza = 500;
        //zmniejszenie ceny podczas sprzedaży przedmiotów handlarzowi/pacjentowi
        public static float RoznicaCenSprzedazy = 0.5f;

        /***** Sekcja Pacjenta *****/
        //Największa liczba chorób jaką może posiadać pacjent
        public static int MaksimumChorobPacjenta = 6;
        //Maksymalny czas oczekiwania na leczenie zanim pacjent nieszpitalny odejdzie
        public static int MaksimumOczekiwaniaPacjenta = 6;

        /***** Sekcja ogólna ****/
        //najwyższy wewnętrzny poziom trudności czyli generowania pacjentow
        public static int MaksymalnyWewnetrznyPoziomTrudnosci = 10;

    }
}