﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author


using System;

namespace ZielarzSilnik
{
    [Flags]
    public enum CzescCiala
    {
  Glowa = 0,
        Oczy =  0x01,
        Uszy = 0x02,
        Nos = 0x04,
        Mozg = 0x08,
        JamaUstna = 0x10,
        Krtan = 0x20,
        Gardlo = 0x40,
        Tchawica = 0x80,
        Oskrzela = 0x100,
        Pluca = 0x200,
        Serce = 0x400,
        Ramiona = 0x800,
        Lokcie = 0x1000,
        Dlonie = 0x2000,
        Szyja = 0x4000,
        Zebra = 0x8000,
        Zoladek = 0x10000,
        Watroba = 0x20000,
        Trzustka = 0x40000,
        Pecherz = 0x80000,
        JelitoCienkie = 0x100000,
        JelitoGrube = 0x200000,
        NarzadyRozrodcze = 0x400000,
        Posladki = 0x800000,
        Uda = 0x1000000,
        Lydki = 0x2000000,
        Stopy = 0x4000000,
        Kostki = 0x8000000,
        Nerki = 0x10000000,
        Brzuch = 0x20000000,
        WieleNarzadow = 0x40000000,
        //zbiorcze
        GorneDrogiOddechowe = JamaUstna | Gardlo | Krtan | Tchawica,
        DolneDrogiOddechowe = Oskrzela | Pluca,
        DrogiOddechowe = GorneDrogiOddechowe | DolneDrogiOddechowe,
        Rece = Ramiona | Lokcie | Dlonie,
        Nogi = Uda | Lydki | Kostki | Stopy,
        Tulow = Brzuch | Zebra,
        UkladTrawienny = Zoladek | JelitoCienkie | JelitoGrube | Watroba | Trzustka,
        UkladMoczowy = Pecherz | Nerki,
        Zewnetrzne = Glowa | Rece | Tulow | Nogi | Uszy | Nos |Szyja | Posladki,
        Wewnetrzne = DrogiOddechowe | UkladTrawienny | UkladMoczowy | NarzadyRozrodcze | Serce | Oczy | Mozg | Zebra,
        //wszystko
        Dowolna = Zewnetrzne | Wewnetrzne | WieleNarzadow
    };

   
 


}