﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using SymulatorZielarza_WarstwaBazowa;
using UnityEngine;
using UnityEngine.UI;

namespace ZielarzSilnik
{
    public class ScenaStartowa : MonoBehaviour
    {
        public Text TekstNowy, TekstKontynuuj, TekstZamknij, TekstPoziomTrudnosci, TekstPoziomJakosci;
        public Text TekstPrzegrana;
        private IStanGry menedzerZapisu;
        private SelektorPlatformy _selektorPlatformy;
        private IMenedzerWejscia _menedzerWejscia;
        private MenedzerPoziomuTrudnosci.PoziomTrudnosci _poziomTrudnosci;

       
        public void WykonajLogicznaAkcje(LogicznaAkcja akcja)
        {
            if (akcja == LogicznaAkcja.KontynuujGre)
                KontyuujGre();
            if (akcja == LogicznaAkcja.NowaGra)
                NowaGra();
            if (akcja == LogicznaAkcja.ZamknijGre)
                Zamknij();
            if (akcja == LogicznaAkcja.ZmienPoziomTrudnosci)
                ZmienPoziomTrudnosci();
            if (akcja == LogicznaAkcja.ZmienPoziomJakosci)
                ZmienPoziomJakosci();
        }

        public void NowaGra()
        {
            menedzerZapisu.WyczyscKlucze();
            menedzerZapisu.ZapiszKlucz("poziomTrudnosci", (int)_poziomTrudnosci);
            menedzerZapisu.ZapiszGre();
            KontyuujGre();
        }
        public void KontyuujGre()
        {
            UnityEngine.SceneManagement.SceneManager.LoadScene("ScenaGlowna");
        }
        public void Zamknij()
        {
            Application.Quit();
        }
        public void ZmienPoziomTrudnosci()
        {
            if (_poziomTrudnosci == MenedzerPoziomuTrudnosci.PoziomTrudnosci.Latwy)
                _poziomTrudnosci = MenedzerPoziomuTrudnosci.PoziomTrudnosci.Trudny;
            else
                _poziomTrudnosci = MenedzerPoziomuTrudnosci.PoziomTrudnosci.Latwy;
            OdswiezPoziomTrudnosci();
        }
        public void ZmienPoziomJakosci()
        {
            int poziom = QualitySettings.GetQualityLevel() + 1;
            if(poziom > 5)
                poziom = 0;
            QualitySettings.SetQualityLevel(poziom);
            OdswiezPoziomJakosci();
        }
        private void OdswiezPoziomTrudnosci()
        {
            menedzerZapisu.ZapiszKlucz("poziomTrudnosci", (int)_poziomTrudnosci);
            menedzerZapisu.ZapiszGre();
            TekstPoziomTrudnosci.text = string.Format(TlumaczCiagow.PodajCiag("poziom_trudnosci_tekst"), TlumaczCiagow.PodajCiag("poziom_" + _poziomTrudnosci.ToString()));
        }
        private void OdswiezPoziomJakosci()
        {
            menedzerZapisu.ZapiszKlucz("poziomJakosci", QualitySettings.GetQualityLevel());
            menedzerZapisu.ZapiszGre();
            TekstPoziomJakosci.text = string.Format(TlumaczCiagow.PodajCiag("poziom_jakosci_tekst"), TlumaczCiagow.PodajCiag("poziom_jakosci_" + QualitySettings.GetQualityLevel()));
        }
        private void SprawdzPrzegrana()
        {
            menedzerZapisu.ZaladujGre();
            string powodPrzegranej = menedzerZapisu.PobierzKluczString("przegrana");
            if (powodPrzegranej != "")
            {
                TekstPrzegrana.gameObject.SetActive(true);
                TekstPrzegrana.text = TlumaczCiagow.PodajCiag(powodPrzegranej);
                menedzerZapisu.WyczyscKlucze();
                menedzerZapisu.ZapiszKlucz("poziomTrudnosci", (int)_poziomTrudnosci);
                menedzerZapisu.ZapiszGre();
            }
            else
                TekstPrzegrana.gameObject.SetActive(false);
        }

        private void SprawdzKontynuacje()
        {
            menedzerZapisu.ZaladujGre();
            if(menedzerZapisu.istniejeKlucz("pozycja_gracza_x"))
                TekstKontynuuj.gameObject.SetActive(true);
            else
                TekstKontynuuj.gameObject.SetActive(false);
        
        }
        private void Start()
        {
            _selektorPlatformy = GetComponent<SelektorPlatformy>();
            if (_selektorPlatformy == null)
                Debug.LogError("Brak selektora platformy!");
            IKonfiguratorSceny konfigurator = _selektorPlatformy.UtworzKonfiguratorSceny();
            konfigurator.UtworzObiektySceny(gameObject);
            _menedzerWejscia = _selektorPlatformy.UtworzMenedzerWejscia();
            _menedzerWejscia.NasluchujWejscie(WykonajLogicznaAkcje);
            menedzerZapisu = _selektorPlatformy.UtworzMenedzerStanuGry();
            if (TekstNowy == null)
                Debug.LogError("Nie ustawiono pola TekstNowy");
            if (TekstKontynuuj == null)
                Debug.LogError("Nie ustawiono pola TekstKontynuuj");
            if (TekstPrzegrana == null)
                Debug.LogError("Nie ustawiono pola TekstPrzegrana");
            if (TekstZamknij == null)
                Debug.LogError("Nie ustawiono pola TekstZamknij");
            if (TekstPoziomTrudnosci == null)
                Debug.LogError("Nie ustawiono pola TekstPoziomTrudnosci");
            if (TekstPoziomJakosci == null)
                Debug.LogError("Nie ustawiono pola TekstPoziomJakosci");
            TekstNowy.text = TlumaczCiagow.PodajCiag("nowy");
            TekstKontynuuj.text = TlumaczCiagow.PodajCiag("kontynuuj");
            TekstZamknij.text = TlumaczCiagow.PodajCiag("zamknij");
            SprawdzPrzegrana();
            SprawdzKontynuacje();
            if (menedzerZapisu.istniejeKlucz("poziomTrudnosci"))
                _poziomTrudnosci = (MenedzerPoziomuTrudnosci.PoziomTrudnosci)menedzerZapisu.PobierzKluczInt("poziomTrudnosci");
            else
                _poziomTrudnosci = MenedzerPoziomuTrudnosci.DomyslnyPoziomTrudnosci;
            if (menedzerZapisu.istniejeKlucz("poziomJakosci"))
                QualitySettings.SetQualityLevel(menedzerZapisu.PobierzKluczInt("poziomJakosci"));
            OdswiezPoziomTrudnosci();
            OdswiezPoziomJakosci();
        }
    }

}
