﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using UnityEngine;

namespace ZielarzSilnik
{
    public class LODWylacznik : MonoBehaviour
    {
        public float MaksymalnaOdleglosc = 50;  //najdalsza odległość od gracza przy której dzieci tego obiektu są wyświetlane
        public float CZASOBLICZEN = 1.4f;

        private float _licznikCzasu;
        private bool _stanAktywnyWidocznosci;

        private void Start()
        {
            _licznikCzasu = CZASOBLICZEN;
            _stanAktywnyWidocznosci = true;
        }

        private void Update()
        {
            _licznikCzasu -= Time.deltaTime;
            if (_licznikCzasu <= 0)
            {
                _licznikCzasu = CZASOBLICZEN;
                bool stanPozadanyWidocznosci = (transform.position - MenedzerGry.InstancjaMenedzeraGry.KontrolerGracza.transform.position).magnitude < MaksymalnaOdleglosc;
                if(stanPozadanyWidocznosci != _stanAktywnyWidocznosci)
                {
                    if (stanPozadanyWidocznosci == false)
                        Ukryj();
                    else
                        Pokaz();
                    _stanAktywnyWidocznosci = stanPozadanyWidocznosci;
                }
            }
        }
        private void Pokaz()
        {
            for (int i = 0; i < transform.childCount; i++)
                transform.GetChild(i).gameObject.SetActive(true);
        }
        private void Ukryj()
        {
            for(int i = 0; i < transform.childCount; i++)
                transform.GetChild(i).gameObject.SetActive(false);
        }
    }
}