﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using SymulatorZielarza_WarstwaBazowa;
using UnityEngine;

namespace SymulatorZielarza_WarstwaWinPC
{
    public class MenedzerWejsciaWinPC : MonoBehaviour, IMenedzerWejscia
    {
        private event DelegatLogicznejAkcji ZdarzenieLogicznejAkcji;

        public void NasluchujWejscie(DelegatLogicznejAkcji sluchacz)
        {
            ZdarzenieLogicznejAkcji += sluchacz;
        }
        public void ZakonczNasluch(DelegatLogicznejAkcji sluchacz)
        {
            ZdarzenieLogicznejAkcji -= sluchacz;
        }

        void Update()
        {
            if (Input.GetKeyDown(KeyCode.P))
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.RozwinPlecak);
            if (Input.GetKeyDown(KeyCode.LeftBracket))
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.PlecakWLewo);
            if (Input.GetKeyDown(KeyCode.RightBracket))
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.PlecakWPrawo);
            if (Input.GetKeyDown(KeyCode.E) || Input.GetMouseButtonDown(0))
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Interakcja);
            if (Input.GetKeyDown(KeyCode.X))
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.WyrzucPrzedmiot);
            if (Input.GetKeyDown(KeyCode.R))
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.UruchomRzemieslnictwo);
            if (Input.GetKeyDown(KeyCode.F1))
            {
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Pomoc);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.KontynuujGre);
            }
            if (Input.GetKeyDown(KeyCode.F2))
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.PrzewodnikDalej);
            if (Input.GetKeyDown(KeyCode.F5))
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.NowaGra);
            if (Input.GetKeyDown(KeyCode.F4))
            {
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.WyjdzDoMenu);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.ZamknijGre);
            }
            if (Input.GetKeyDown(KeyCode.Equals))
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.CzasSzybciej);
            if (Input.GetKeyDown(KeyCode.Minus))
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.CzasWolniej);
            if (Input.anyKeyDown || Input.GetMouseButtonDown(0) || Input.GetMouseButtonDown(1))
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            if (Input.GetKeyDown(KeyCode.F6))
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.ZmienPoziomTrudnosci);
            if (Input.GetKeyDown(KeyCode.F7))
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.ZmienPoziomJakosci);
        }

    }
}