﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using SymulatorZielarza_WarstwaBazowa;
using UnityEngine;
using UnityEngine.UI;
using ZielarzSilnik;
using UnityEngine.XR;

namespace SymulatorZielarza_WarstwaWinPC
{
    public  class KonfiguratorScenyWinPC : IKonfiguratorSceny
    {
        public void UtworzObiektySceny(GameObject glownyObiektSceny)
        {
            AssetBundle pakiet = MenedzerPakietowZasobow.Instancja.PodajPakiet("klientwindows");
            if (pakiet == null)
                Debug.LogError("Brak pakietu z zasobami dla wersji Windows! ");

            if (glownyObiektSceny.GetComponent<MenedzerGry>() != null)
            {
                MenedzerGry menedzerGry = glownyObiektSceny.GetComponent<MenedzerGry>();
                GameObject kontroler1PSzablon = pakiet.LoadAsset<GameObject>("FPSController");
                GameObject kontroler1P = GameObject.Instantiate(kontroler1PSzablon, null);
                menedzerGry.KontrolerGracza = kontroler1P;
                menedzerGry.ObiektPlecaka = kontroler1P.GetComponentInChildren<Plecak>();
                MenedzerUI menedzerUI = menedzerGry.GetComponent<MenedzerUI>();
                menedzerUI.KanwaOpisu = GameObject.Find("KanwaOpisu").GetComponent<Canvas>();
                menedzerUI.KanwaMalegoInfo = GameObject.Find("KanwaMalegoInfo").GetComponent<Canvas>();
                menedzerUI.KanwaPomocy = GameObject.Find("KanwaPomocy").GetComponent<Canvas>();
                menedzerUI.TekstZlota = GameObject.Find("TekstZloto").GetComponent<Text>();
                menedzerUI.KropkiSzybkosciCzasu = GameObject.Find("ObrazekKropki").GetComponent<Image>();
                menedzerUI.ObiektPlecaka = GameObject.Find("Plecak").GetComponent<Plecak>();
                menedzerGry.gameObject.AddComponent<MenedzerWejsciaWinPC>();
            } else if(glownyObiektSceny.GetComponent<ScenaStartowa>() != null)
            {
                glownyObiektSceny.AddComponent<MenedzerWejsciaWinPC>();
                ScenaStartowa scenaStartowa = glownyObiektSceny.GetComponent<ScenaStartowa>();
                GameObject kontroler1PSzablon = pakiet.LoadAsset<GameObject>("FirstPersonCharacterStartScene");
                GameObject kontroler1P = GameObject.Instantiate(kontroler1PSzablon, null);
                scenaStartowa.TekstKontynuuj = GameObject.Find("TekstKontynuuj").GetComponent<Text>();
                scenaStartowa.TekstNowy = GameObject.Find("TekstNowy").GetComponent<Text>();
                scenaStartowa.TekstPoziomTrudnosci = GameObject.Find("TekstPoziomTrudnosci").GetComponent<Text>();
                scenaStartowa.TekstPrzegrana = GameObject.Find("TekstPrzegrana").GetComponent<Text>();
                scenaStartowa.TekstZamknij = GameObject.Find("TekstZamknij").GetComponent<Text>();
                scenaStartowa.TekstPoziomJakosci = GameObject.Find("TekstPoziomJakosci").GetComponent<Text>();
                scenaStartowa.TekstKontynuuj.GetComponent<Button>().onClick.AddListener(scenaStartowa.KontyuujGre);
                scenaStartowa.TekstNowy.GetComponent<Button>().onClick.AddListener(scenaStartowa.NowaGra);
                scenaStartowa.TekstPoziomTrudnosci.GetComponent<Button>().onClick.AddListener(scenaStartowa.ZmienPoziomTrudnosci);
                scenaStartowa.TekstPoziomJakosci.GetComponent<Button>().onClick.AddListener(scenaStartowa.ZmienPoziomJakosci);
                scenaStartowa.TekstZamknij.GetComponent<Button>().onClick.AddListener(scenaStartowa.Zamknij);

            }
            XRSettings.enabled = false;
            glownyObiektSceny.AddComponent<SystemDniaNocyPogody>();
            if (GameObject.Find("Slonce") != null)
                glownyObiektSceny.GetComponent<SystemDniaNocyPogody>().Slonce = GameObject.Find("Slonce").GetComponent<Light>();
        }


    }
}