﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author


using System;
using System.Collections.Generic;
using System.Xml.Linq;
using UnityEngine;

namespace ZielarzSilnik
{
    public enum SposobPodania { Dowolny, WewnetrznieMikstura, WewnetrznieWCalosci, ZewnetrznieNacieranie, ZewnetrznieKrem, Inhalacja ,
        Wewnetrznie = WewnetrznieMikstura | WewnetrznieWCalosci,
        Zewnetrznie = ZewnetrznieNacieranie | ZewnetrznieKrem | Inhalacja
    };
    
    // substancja leczaca/trujaca
    public class Substancja
    {
        public string Nazwa;                        // nazwa substancji(identyfikator ciagu nazwy)
        public List<LeczenieZdarzenia> Leczenie;    // wartosc leczenia jednostki substancji
        public float Wielkosc;                      // liczba jednostek bazowych substancji
        public string NazwaJednostki;               // nazwa jednostki bazowej substancji(identyfikator ciagu nazwy)
        public List<WplywNaParametr> WplywOgolny;   // lista wplywow na parametry ogolne postaci

        public Substancja()
        {
            Leczenie = new List<LeczenieZdarzenia>();
            WplywOgolny = new List<WplywNaParametr>();
        }

        //klon innej substancji
        public Substancja(Substancja klonujZTejSubstancji)
        {
            Nazwa = klonujZTejSubstancji.Nazwa;
            Leczenie = new List<LeczenieZdarzenia>();
            foreach (LeczenieZdarzenia klonLeczenia in klonujZTejSubstancji.Leczenie)
                Leczenie.Add(new LeczenieZdarzenia(klonLeczenia));
            Wielkosc = klonujZTejSubstancji.Wielkosc;
            NazwaJednostki = klonujZTejSubstancji.NazwaJednostki;
            WplywOgolny = new List<WplywNaParametr>();
            foreach (WplywNaParametr klonWplywu in klonujZTejSubstancji.WplywOgolny)
                WplywOgolny.Add(new WplywNaParametr(klonWplywu));
        }

        //zaladuj dane substancji z pojedynczego wezla XML 
        public void ZaladujDane(XElement elementXMLDanych)
        {
            Wielkosc = 1;
            if (elementXMLDanych.Attribute("nazwa") == null)
                Debug.LogError("Brak atrybutu nazwa w elemencie danych " + elementXMLDanych.ToString());
            else
                Nazwa = elementXMLDanych.Attribute("nazwa").Value;
            if (elementXMLDanych.Attribute("nazwaJednostki") != null)
                NazwaJednostki = elementXMLDanych.Attribute("nazwaJednostki").Value;
            else
                NazwaJednostki = "";
            foreach (XElement podElement in elementXMLDanych.Elements())
            {
                if (podElement.Name == "leczenie")
                {
                    LeczenieZdarzenia leczenieElement = new LeczenieZdarzenia(podElement);
                    Leczenie.Add(leczenieElement);
                }
                if (podElement.Name == "wplywOgolny")
                {
                    WplywNaParametr wplyw = new WplywNaParametr(podElement);
                    WplywOgolny.Add(wplyw);
                }
            }
           
        }
    }

}
