﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author


using System.Collections.Generic;
using System.Text;
using UnityEngine;

namespace ZielarzSilnik
{

    
    public class Pacjent: Postac
    {
        public const int MAKSIMUM_CHOROB = 3;
        public static int NastepneID = 0;

        public bool JestZywy {  get { return PobierzZdolnosc("Zdrowie") > 0; } }
        public bool JestZdrowy { get { return _aktualneZdarzenia.Count == 0; } }
        public int IDPacjenta { get; private set; }
        public string PrzyczynaZgonu { get; private set; }
        public int LiczbaAktualnychZdarzen { get { return _aktualneZdarzenia.Count; } }

        private List<ZdarzenieMedyczne> _aktualneZdarzenia;          // lista aktualnych zdarzen medycznych
        private List<CzescCiala> _wylaczoneLokalizacje;       //lista lokalizacji dla ktorych nie mozna juz utworzyc zdarzen medycznych bo... dana czesc ciala nie funkcjonuje calkowicie (np. amputowana reka nie moze zostac odmrozona)

        public Pacjent() : base()
        {
            _zdolnosci.Add("Zdrowie", 100);                 //ogolny poziom zycia, po spadku do 0 - pacjent umiera z powodu niewydolnosci ogolnej organizmu
            _zdolnosci.Add("Sila", 100);                    //sila miesni
            _zdolnosci.Add("Witalnosc", 100);               //poziom odpornosci oraz zdolnosci regenracji, kazde zdarzenie zmniejsza sie co godzine o (Witalnosc/50) % swojej wartosci oraz -0.01 * Witalnosc/100 na godzine
            _aktualneZdarzenia = new List<ZdarzenieMedyczne>();
            _wylaczoneLokalizacje = new List<CzescCiala>();
            IDPacjenta = ++NastepneID;
            PrzyczynaZgonu = "";
        }

        //dodaje nowe zdarzenie pierwotne (nowe choroby)
        public void DodajNoweZdarzenie(ZdarzenieMedyczne zdarzenie)
        {
         //   Debug.Log("wylosowano " + zdarzenie.Nazwa + " " + zdarzenie.Lokalizacja);
            _aktualneZdarzenia.Add(zdarzenie);
        }

        //obsluga zdarzen medycznych godzinowo
        public void GodzinowaObslugaZdarzen()
        {
            List<ZdarzenieMedyczne> wszystkieNoweZdarzenia = new List<ZdarzenieMedyczne>();  //skumulowana lista nowych zdarzen medycznych
            List<ZdarzenieMedyczne> zdarzeniaDoUsuniecia = new List<ZdarzenieMedyczne>();     //zdarzenia do usuniecia
            foreach(ZdarzenieMedyczne zdarzenie in _aktualneZdarzenia)
            {
                List<ZdarzenieMedyczne> noweZdarzenia = MenedzerZielarstwa.Instancja.PrzetworzStanZdarzeniaMedycznego(zdarzenie);
                wszystkieNoweZdarzenia.AddRange(noweZdarzenia);
                //obsluzmy jeszcze witalnosc pacjenta
                zdarzenie.Sila = zdarzenie.Sila * (1 - PobierzZdolnosc("Witalnosc") / 5000f) - 0.01f * (PobierzZdolnosc("Witalnosc") / 50f);
                //obsluz wplyw zdarzenia na parametry ogolne
                foreach (WplywNaParametr wplyw in zdarzenie.SzkodliwoscOgolna)
                    UstawZdolnosc(wplyw.Parametr, PobierzZdolnosc(wplyw.Parametr) + wplyw.Wartosc * zdarzenie.Sila * MechanikaCzesciCiala.MnoznikCzesciCiala(zdarzenie.Lokalizacja));
                //smiertelnosc gwaltowna zdarzenia
                if (zdarzenie.Smiertelnosc > 0 && Random.Range(0f, 1f) < (zdarzenie.Smiertelnosc * MechanikaCzesciCiala.MnoznikCzesciCiala(zdarzenie.Lokalizacja)))
                {
                    PrzyczynaZgonu = string.Format("{0} {1}", zdarzenie.Nazwa, zdarzenie.Lokalizacja);
                        UstawZdolnosc("Zdrowie", 0);
                }
                //zdarzenie w wyniku przetworzenia moglo oslabnac do zera - do usuniecia
                if (zdarzenie.Sila <= 0)
                    zdarzeniaDoUsuniecia.Add(zdarzenie);
                //zdarzenie jednorazowe bedzie usuniete po przetworzeniu
                if (zdarzenie.Jednorazowe)
                    zdarzeniaDoUsuniecia.Add(zdarzenie);
            }
            _aktualneZdarzenia.AddRange(wszystkieNoweZdarzenia);
            //musimy jeszcze przejrzec liste aby polaczyc zdarzenia, ktore moga byc identyczne i dotyczyc tego samego miejsca (stworzone z dwoch roznych chorob) np. dwa zapalenia gardla redukuja sie do jednego mocniejszego
            for(int i = 0; i < _aktualneZdarzenia.Count; i++)
                for (int j = i + 1; j < _aktualneZdarzenia.Count; j++)
                {
                    if(_aktualneZdarzenia[i].Nazwa == _aktualneZdarzenia[j].Nazwa && (_aktualneZdarzenia[i].Lokalizacja & _aktualneZdarzenia[j].Lokalizacja) != 0)
                    {
                        //zdarzenie bedzie suma sil zdarzen i najwiekszym zaostrzeniem, a zdarzenie2 zostanie usuniete
                        _aktualneZdarzenia[i].Sila = _aktualneZdarzenia[i].Sila + _aktualneZdarzenia[j].Sila;
                        _aktualneZdarzenia[i].Zaostrzenie = _aktualneZdarzenia[i].Zaostrzenie > _aktualneZdarzenia[j].Zaostrzenie ? _aktualneZdarzenia[i].Zaostrzenie : _aktualneZdarzenia[j].Zaostrzenie;
                        _aktualneZdarzenia[i].Normalizuj();
                        zdarzeniaDoUsuniecia.Add(_aktualneZdarzenia[j]);
                    }
                }
            //obsluga amputacji 
            foreach (ZdarzenieMedyczne zdarzenie in _aktualneZdarzenia)
                if (zdarzenie.Nazwa == "Amputacja" && !_wylaczoneLokalizacje.Contains(zdarzenie.Lokalizacja))
                {
                    _wylaczoneLokalizacje.Add(zdarzenie.Lokalizacja);
                }
            foreach (ZdarzenieMedyczne zdarzenie in _aktualneZdarzenia)
                if (_wylaczoneLokalizacje.Contains(zdarzenie.Lokalizacja))
                    zdarzeniaDoUsuniecia.Add(zdarzenie);
            //usuniecie niepotrzebnych zdarzen
            foreach (ZdarzenieMedyczne zdarzenie in zdarzeniaDoUsuniecia)
                _aktualneZdarzenia.Remove(zdarzenie);        
        }
        //losuje choroby tak dlugo az wylosuje conajmniej jedna, ale nie mniej niz 100 losowan i nie wiecej niz 1000 losowan
        public void WylosujChoroby()
        {
            int liczbaLosowan = 0;
            do
            {
                ZdarzenieMedyczne zdarzenie = MenedzerZielarstwa.Instancja.UtworzPierwotneZdarzenieMedyczne();
                if (zdarzenie != null)
                    DodajNoweZdarzenie(zdarzenie);
                liczbaLosowan++;
            } while (_aktualneZdarzenia.Count < MAKSIMUM_CHOROB && liczbaLosowan < 100 || (liczbaLosowan < 1000 && _aktualneZdarzenia.Count == 0));
           
        }
        public string ZrzutDebugZdarzen()
        {
            StringBuilder log = new StringBuilder();
            log.Append(string.Format("{0} {1}: {2}, {3}: {4}, {5}: {6} \n\r",
                 TlumaczCiagow.PodajCiag("Pacjent") + IDPacjenta, TlumaczCiagow.PodajCiag("ZdrowieSkrot"), ZrobTekst(PobierzZdolnosc("Zdrowie")), TlumaczCiagow.PodajCiag("SilaSkrot"), ZrobTekst(PobierzZdolnosc("Sila")), TlumaczCiagow.PodajCiag("WitalnoscSkrot"), ZrobTekst(PobierzZdolnosc("Witalnosc"))));
            foreach (ZdarzenieMedyczne zdarzenie in _aktualneZdarzenia)
                log.Append(" * " + zdarzenie.DajLadnaNazwe() + " " + ZrobTekst(zdarzenie.Sila) + " (" + ZrobTekst(zdarzenie.Zaostrzenie) + ")\n\r");
            foreach (CzescCiala wykluczonaCzescCiala in _wylaczoneLokalizacje)
                log.Append( string.Format(" # {0}: {1} \n\r", TlumaczCiagow.PodajCiag("Amputowano"), wykluczonaCzescCiala));
            return log.ToString();
        }
        private string ZrobTekst(float liczba)
        {
            return liczba.ToString("F2");

        }
    }


}
