﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using System;
using UnityEngine;
using UnityEngine.UI;

namespace ZielarzSilnik
{


    public class MenedzerUI : MonoBehaviour
    {
        public static MenedzerUI Instancja { get; private set; }
        public const float ZASIEGDOTKNIECIA = 2.5f;     // maksymalny zasieg do obiektu aby mozna bylo z nim przeprowadzic interakcje
        public Sprite WskaznikWlaczony, WskaznikWylaczony;
        public Text OpisPrzedmiotu;

        private SpriteRenderer _wskaznikKamery;
        private Canvas _kanwaOpisu;
        private GameObject _poprzednioPatrzylismy;

        private void Awake()
        {
            if (Instancja != null && Instancja != this)
                throw new Exception("Niedozwolone tworzenie kolejnej kopii klasy MenedzerUI");
            Instancja = this;
        }

        void Start()
        {
            _wskaznikKamery = MenedzerGry.InstancjaMenedzeraGry.KontrolerGracza.GetComponentInChildren<SpriteRenderer>();
            _kanwaOpisu = _wskaznikKamery.GetComponentInChildren<Canvas>();
            _poprzednioPatrzylismy = gameObject; //patrzy tu sam na siebie, tym trickiem wymuszamy zmiane w pierwszym Update
        }


        void Update()
        {
#if UNITY_EDITOR
            if (Input.GetKeyDown(KeyCode.F1))
                Debug.Log(MenedzerGry.InstancjaMenedzeraGry.WykonajMasowyTestChorob(100));
#endif
            GameObject patrzymy = NaCoPatrzyKamera();
            if (_poprzednioPatrzylismy != patrzymy)
            {
                if (patrzymy != null && patrzymy.GetComponent<AktywnyObiekt>() != null)
                {
                    _wskaznikKamery.sprite = WskaznikWlaczony;
                    OpisPrzedmiotu.text = patrzymy.GetComponent<AktywnyObiekt>().Nazwa;                    
                    _kanwaOpisu.gameObject.SetActive(true);
                }
                else
                {
                    _wskaznikKamery.sprite = WskaznikWylaczony;
                    _kanwaOpisu.gameObject.SetActive(false);
                }
            }
            _poprzednioPatrzylismy = patrzymy;
        }


        public GameObject NaCoPatrzyKamera()
        {
            RaycastHit hit;
            Vector3 punktCentralny = Camera.main.ScreenToWorldPoint(new Vector3(Screen.width / 2, Screen.height / 2, 0.1f));
            if (Physics.Raycast(punktCentralny, Camera.main.transform.forward, out hit))
                if (hit.distance < ZASIEGDOTKNIECIA)
                    return hit.collider.gameObject;
            return null;

        }
    }
}