﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using System.Collections.Generic;
using System.Xml.Linq;
using UnityEngine;

namespace ZielarzSilnik
{

    public sealed class MenedzerZielarstwa
    {
        private List<WzorzecZdarzeniaMedycznego> _wzorceZdarzen;  //lista zdarzen med. zaladowane z konfiguracji
        private List<Substancja> _wzorceSubstancji;              // dostepne w grze listy substancji medycznych zaladowane z konfiguracji
        private List<PrzedmiotLeczniczy> _wzorcePrzedmiotow;     // wzorce kompletnych przedmiotow leczniczych 
        private List<SzansaNaZdarzenie> _wzorceChorobPierwotnych;           // list przejsc miedzy zdarzeniami z konfiguracji, tylko przejscia pierowtne (poczatek choroby)
        private List<SzansaNaZdarzenie> _wzorceChorobZaleznych;           // list przejsc miedzy zdarzeniami z konfiguracji, tylko przejscia zalezne (nowe objawy choroby)
        private List<Pacjent> _pacjenciSzpitalni;                // pacjenci chorzy obloznie
        private List<Pacjent> _pacjencjiWolni;                   // pacjenci przychodzacy

        private static MenedzerZielarstwa _instancja;
        public static MenedzerZielarstwa Instancja
        {
            get
            {
                if (_instancja == null)
                    _instancja = new MenedzerZielarstwa();
                return _instancja;
            }
        } 
        private MenedzerZielarstwa ()
        {
            _wzorceZdarzen = new List<WzorzecZdarzeniaMedycznego>();
            _wzorceSubstancji = new List<Substancja>();
            _wzorcePrzedmiotow = new List<PrzedmiotLeczniczy>();
            _pacjenciSzpitalni = new List<Pacjent>();
            _pacjencjiWolni = new List<Pacjent>();
            _wzorceChorobPierwotnych = new List<SzansaNaZdarzenie>();
            _wzorceChorobZaleznych = new List<SzansaNaZdarzenie>();
        }

        public void ZaladujDane()
        {
            try
            {
                //zdarzenia   
                IEnumerable<XElement> listaWezlowZdarzen = Dodatki.Funkcje.ZaladujZasobXMLJakoListeElementow("data/zdarzenia", "zdarzenia", null);
                if (listaWezlowZdarzen != null)
                {
                    foreach (XElement element in listaWezlowZdarzen)
                    {
                        WzorzecZdarzeniaMedycznego noweZdarzenie = new WzorzecZdarzeniaMedycznego();
                        noweZdarzenie.ZaladujDane(element);
                        _wzorceZdarzen.Add(noweZdarzenie);
                    }
                }
                //szanse 
                IEnumerable<XElement> listaWezlowSzans = Dodatki.Funkcje.ZaladujZasobXMLJakoListeElementow("data/szanse", "szanse", null);
                if (listaWezlowSzans != null)
                {
                    foreach (XElement element in listaWezlowSzans)
                    {
                        SzansaNaZdarzenie nowaSzansaNaZdarzenie = new SzansaNaZdarzenie();
                        nowaSzansaNaZdarzenie.ZaladujDane(element);
                        if(nowaSzansaNaZdarzenie.TypZdarzeniaPoprzedniego == null)
                            _wzorceChorobPierwotnych.Add(nowaSzansaNaZdarzenie);
                        else
                            _wzorceChorobZaleznych.Add(nowaSzansaNaZdarzenie);
                    }
                }
                //substancje
                IEnumerable<XElement> listaWezlowSubstancji = Dodatki.Funkcje.ZaladujZasobXMLJakoListeElementow("data/substancje", "substancje", null);
                if (listaWezlowSzans != null)
                {
                    foreach (XElement element in listaWezlowSubstancji)
                    {
                        Substancja nowaSubstancja = new Substancja();
                        nowaSubstancja.ZaladujDane(element);
                        _wzorceSubstancji.Add(nowaSubstancja);
                    }
                }
                //przedmioty (ladowanie substancji musi tu byc skonczone poniewaz sa one uzywane do tworzenia klonow substancji aktywnych w przedmiotach)
                IEnumerable<XElement> listaWezlowPrzedmiotow = Dodatki.Funkcje.ZaladujZasobXMLJakoListeElementow("data/przedmioty", "przedmioty", null);
                if (listaWezlowPrzedmiotow != null)
                {
                    foreach (XElement element in listaWezlowPrzedmiotow)
                    {
                        PrzedmiotLeczniczy nowyPrzedmiot = new PrzedmiotLeczniczy();
                        nowyPrzedmiot.ZaladujDane(element, _wzorceSubstancji);
                        _wzorcePrzedmiotow.Add(nowyPrzedmiot);
                    }
                }

            }
            catch (System.Exception wyjatek)
            {
                Debug.LogError("Ogólny wyjątek: " + wyjatek.Message);
            }
        }

        //tworzy nowe, losowe pierwotne zdarzenie medyczne (nowa chorobe), poniewaz bierze pod uwage prawdopodobienstwo zajscia chorob, moze zwrocic null oznaczajacy ze zadna nie zostala wylosowana
        public ZdarzenieMedyczne UtworzPierwotneZdarzenieMedyczne()
        {
            SzansaNaZdarzenie wylosowaneZdarzenie = null;
            foreach (SzansaNaZdarzenie szansa in _wzorceChorobPierwotnych)
                if (Random.Range(0, 1f) < szansa.Prawdopodobienstwo)
                    wylosowaneZdarzenie = szansa;
            if (wylosowaneZdarzenie != null)
            {             
                WzorzecZdarzeniaMedycznego nowyWzorzec = null;
                foreach (WzorzecZdarzeniaMedycznego wzorzec in _wzorceZdarzen)
                    if (wzorzec.Nazwa == wylosowaneZdarzenie.TypZdarzeniaNastepnego)
                        nowyWzorzec = wzorzec;
                if(nowyWzorzec == null)
                {
                    Debug.LogError("Nie można znalezc wzorca zdarzenia medycznego " + wylosowaneZdarzenie.TypZdarzeniaNastepnego);
                    return null;
                }
                ZdarzenieMedyczne zdarzenie = new ZdarzenieMedyczne(nowyWzorzec);
                zdarzenie.Lokalizacja = wylosowaneZdarzenie.LokalizacjaNastepna;
                zdarzenie.Sila = Random.Range(0.001f, 1f);
                zdarzenie.Zaostrzenie = Random.Range(0f, 2f) - 1f;
                return zdarzenie;
            }
            else return null;
        }
    }
}