﻿ // **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using UnityEngine;
using System.Collections.Generic;
using System;

namespace ZielarzSilnik
{   
    // Trzyma w gotowości obiekty często używane na scenie po to aby jak najrzadziej tworzyć je i niszczyć co obniża szybkość gry
    // Obiekty sa tworzone tylko gdy naprawdę potrzebne.
    // Na scenie zapasowe obiekty trafiają jako dzieci do obiektu który posiada ten komponent.
    public class PulaAktywnychPrzedmiotow: MonoBehaviour
    {
        //maksymalna liczba wolnych obiektów danego typu na liście zanim lista zacznie być skracana
        public const int MAKSIMUMOBIEKTOWWPULI = 32;
        public static PulaAktywnychPrzedmiotow Instancja { get; private set; }
        //obiekty oznaczone jako nieużywane, klucz to nazwa obiektu (wzorca w zasobach), wartość - lista wolnych obiektów danego typu
        private Dictionary<string, List<GameObject>> _wolneObiekty;   
        //Wzorce do tworzenia obiektów załadowane z Resources. Klucz to nazwa wzorca, a wartość to załadowany wzorzec.
        private Dictionary<string, GameObject> _wzorceObiektow;    
          
        //Główna funkcja podająca obiekt z puli. Tworzy obiekty jeśli brakuje ich w puli.
        public GameObject PodajObiekt( string nazwa)
        {
            GameObject zwracanyObiekt = null;
            InicjujListy(nazwa);
            if (_wolneObiekty[nazwa].Count == 0)    //czyżby brakowało obiektów w puli? pechowo - trzeba utworzyć nowe
                GenerujObiekt(nazwa);
            if (_wolneObiekty[nazwa].Count > 0)
            {                
                zwracanyObiekt = _wolneObiekty[nazwa][0];
                _wolneObiekty[nazwa].RemoveAt(0);
                // obiekty są utrzymywane w nieaktywności a więc musimy je aktywowąc łącznie z 
                zwracanyObiekt.SetActive(true);
               
                    return zwracanyObiekt;
            }
            Debug.LogError("Brak możliwości utworzenia obiektu w puli dla nazwy: " + nazwa);
            return null;
        }
    
        //Zwolnienie obiektu, który przestaje być używany - wstawiamy go na listę wolnych i dezaktywujemy. Listy są zmniejszane tylko przy zbyt dużym rozmiarze.
        public void ZwolnijObiekt( GameObject niepotrzebnyObiekt)
        {
            if (niepotrzebnyObiekt != null)
            {            
                InicjujListy(niepotrzebnyObiekt.name);
                //włóż go na listę wolnych obiektów, no chyba że na liscie jest już ich wiele - wtedy szansa że będzie potrzebna ta instancja jest mała i usuwamy z listy aby ich rozmiary nie robiły się ogromne
                if (_wolneObiekty[niepotrzebnyObiekt.name].Count > MAKSIMUMOBIEKTOWWPULI)
                {
                    Destroy(niepotrzebnyObiekt);
                }
                else
                {
                    _wolneObiekty[niepotrzebnyObiekt.name].Add(niepotrzebnyObiekt);
                    niepotrzebnyObiekt.transform.parent = transform;
                    if (niepotrzebnyObiekt.GetComponent<AktywnyObiekt>())
                        niepotrzebnyObiekt.GetComponent<AktywnyObiekt>().WyczyscUzywanyObiekt();
                    if (niepotrzebnyObiekt.GetComponent<Przedmiot>())
                        niepotrzebnyObiekt.GetComponent<Przedmiot>().WyczyscUzywanyObiekt();
                    niepotrzebnyObiekt.SetActive(false);
                }
            }
        }       
        // initialization of list of object's of given type
        private void InicjujListy(string nazwa)
        {
            if (!_wolneObiekty.ContainsKey(nazwa))
            {
                _wolneObiekty.Add(nazwa, new List<GameObject>());
            }
        }
        private void UtworzWzorzec(string nazwaObiektu)
        {
            if (nazwaObiektu == null || nazwaObiektu == "")
                Debug.LogError("Nieprawidłowa nazwa wzorca do utworzenia");
            else
            {
                GameObject szablon = Resources.Load<GameObject>("Prefaby/" + nazwaObiektu);
                if (szablon == null)
                    Debug.LogError("Nie można załadować z zasobów obiektu: " + nazwaObiektu);

            //    szablon.transform.parent = transform;
                szablon.SetActive(false);
                _wzorceObiektow.Add(nazwaObiektu, szablon);
            }
        }
        //Tworzy nowy obiekt sceny o podanej nazwie, będzie on sklonowany ze wzorca a wzorzec utworzony w razie potrzeby
        private void GenerujObiekt(string nazwa)
        {
            if (!_wzorceObiektow.ContainsKey(nazwa))
                UtworzWzorzec(nazwa);
            if (_wzorceObiektow.ContainsKey(nazwa))
            {
                GameObject newGO = Instantiate(_wzorceObiektow[nazwa], transform.position, _wzorceObiektow[nazwa].transform.rotation);
                newGO.name = nazwa;
                newGO.transform.parent = transform;
               
                _wolneObiekty[nazwa].Add(newGO);
            }
        }
        private void Awake()
        {
            if (Instancja != null && Instancja != this)
                throw new Exception("Niedozwolone tworzenie kolejnej kopii klasy PulaAktywnychPrzedmiotow");
            Instancja = this;
            _wolneObiekty = new Dictionary<string, List<GameObject>>();
            _wzorceObiektow = new Dictionary<string, GameObject>();
        }

    }
}