﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

namespace ZielarzSilnik
{

    public class MenedzerPoziomuTrudnosci
    {
        public enum PoziomTrudnosci { Latwy, Trudny };

        public static PoziomTrudnosci DomyslnyPoziomTrudnosci { get { return PoziomTrudnosci.Latwy; } }

        public static void KonfigurujPoziomTrudnosci(PoziomTrudnosci poziomTrudnosci)
        {
            if (poziomTrudnosci == PoziomTrudnosci.Latwy)
            {

                KonfiguratorGry.ZnaneRecepturyGracza = new string[12] { "RecepturaZupaPomidorowa", "RecepturaNalewkaSosnowa", "RecepturaNalewkaBrzozowa", "RecepturaMascSosnowa", "RecepturaMascNagietkowa", "RecepturaNalewkaNagietkowa", "RecepturaWyciagZKoryWierzby", "RecepturaKoktajlOwocowy", "RecepturaSyropSzalwiowy", "RecepturaHerbataZiolowa", "RecepturaKapustaKiszona", "RecepturaGulasz" };
                KonfiguratorGry.PoczatkoweZlotoGracza = 350;
                KonfiguratorGry.HonorariumZaLeczenieSzpitalne = 75;
                KonfiguratorGry.HonorariumZaWyleczenie = 30;
                KonfiguratorGry.ReputacjaZaWyleczenie = 1.1f;
                KonfiguratorGry.ReputacjaZaSmierc = 0.96f;
                KonfiguratorGry.ReputacjaZaChorobe = 0.99f;
                KonfiguratorGry.RoznicaCenSprzedazy = 0.6f;
                KonfiguratorGry.MaksimumOczekiwaniaPacjenta = 9;
                KonfiguratorGry.MaksymalnyWewnetrznyPoziomTrudnosci = 6;
            }
            else
            {
                KonfiguratorGry.ZnaneRecepturyGracza = new string[1] { "RecepturaZupaPomidorowa" };
                KonfiguratorGry.PoczatkoweZlotoGracza = 100;
                KonfiguratorGry.HonorariumZaLeczenieSzpitalne = 50;
                KonfiguratorGry.HonorariumZaWyleczenie = 20;
                KonfiguratorGry.ReputacjaZaWyleczenie = 1.08f;
                KonfiguratorGry.ReputacjaZaSmierc = 0.90f;
                KonfiguratorGry.ReputacjaZaChorobe = 0.99f;
                KonfiguratorGry.RoznicaCenSprzedazy = 0.4f;
                KonfiguratorGry.MaksimumOczekiwaniaPacjenta = 6;
                KonfiguratorGry.MaksymalnyWewnetrznyPoziomTrudnosci = 10;
            }
        }
    }
}