﻿
// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using System.Collections.Generic;
using System.Text;
using UnityEngine;

namespace ZielarzSilnik
{
    public class TesterChorob : MonoBehaviour
    {
        public string WykonajMasowyTestChorob(int liczba)
        {
            StringBuilder wynik = new StringBuilder();
            Dictionary<string, int> przyczynyZgonow = new Dictionary<string, int>();

            int wyleczono = 0;
            int zmarlBezPrzyczyny = 0;
            int nieWylosowal = 0;
            for (int i = 0; i < liczba; i++)
            {
                Pacjent pacjent = new Pacjent(MenedzerGry.InstancjaMenedzeraGry.WewnetrznyPoziomTrudnosci);
                pacjent.WylosujChoroby(UnityEngine.Random.Range(0, 2) == 0, UnityEngine.Random.Range(0, KonfiguratorGry.MaksymalnyWewnetrznyPoziomTrudnosci + 1));
                if (pacjent.JestZdrowy)
                    nieWylosowal++;
                while (!pacjent.JestZdrowy && pacjent.JestZywy)
                {
                    pacjent.GodzinowaObslugaZdarzen();
                }
                if (pacjent.JestZdrowy)
                    wyleczono++;
                else if (pacjent.PrzyczynaZgonu == "")
                    zmarlBezPrzyczyny++;
                else
                {
                    if (przyczynyZgonow.ContainsKey(pacjent.PrzyczynaZgonu))
                        przyczynyZgonow[pacjent.PrzyczynaZgonu]++;
                    else
                        przyczynyZgonow.Add(pacjent.PrzyczynaZgonu, 1);
                }
            }
            foreach (string przyczyna in przyczynyZgonow.Keys)
                wynik.Append("Zmarło z powodu " + przyczyna + ": " + (100 * przyczynyZgonow[przyczyna] / liczba).ToString() + "% pacjentów. \n\r");
            wynik.Append("Zmarło z wycieńczenia: " + (100 * zmarlBezPrzyczyny / liczba).ToString() + "% pacjentów.\n\r");
            wynik.Append("Wyleczono: " + (100 * wyleczono / liczba).ToString() + "% pacjentów.\n\r");
            wynik.Append("Nie wylosował chorów: " + (100 * nieWylosowal / liczba).ToString() + "% pacjentów.\n\r");
            return wynik.ToString();
        }

      
        public string WykonajMasowyTestPrzedmiotu(int liczbaTestow, string nazwaPrzedmiotu)
        {
            StringBuilder wynik = new StringBuilder();
           
                PrzedmiotLeczniczy leczniczy = MenedzerZielarstwa.Instancja.UtworzPrzedmiotLeczniczy(nazwaPrzedmiotu);
            if (leczniczy != null)
            {
                int wyleczono = 0;
                int zmarlBezPrzyczyny = 0;
                
                for (int i = 0; i < liczbaTestow; i++)
                {
                    Pacjent pacjent = new Pacjent(MenedzerGry.InstancjaMenedzeraGry.WewnetrznyPoziomTrudnosci);
                    pacjent.WylosujChoroby(UnityEngine.Random.Range(0, 2) == 0, UnityEngine.Random.Range(0, KonfiguratorGry.MaksymalnyWewnetrznyPoziomTrudnosci + 1));
                    pacjent.DodajPrzedmiotLeczacy(leczniczy);

                    while (!pacjent.JestZdrowy && pacjent.JestZywy)
                    {
                        if (UnityEngine.Random.Range(0, 12) == 0)
                            pacjent.DodajPrzedmiotLeczacy(leczniczy);
                        pacjent.GodzinowaObslugaZdarzen();
                    }
                    if (pacjent.JestZdrowy)
                        wyleczono++;
                    else if (pacjent.PrzyczynaZgonu == "")
                        zmarlBezPrzyczyny++;
                }
                
                wynik.Append("Wynik dla przedmiotu " + nazwaPrzedmiotu + "\n");
                wynik.Append("Zmarło z wycieńczenia: " + (100 * zmarlBezPrzyczyny / liczbaTestow).ToString() + "% pacjentów.\n\r");
                wynik.Append("Wyleczono: " + (100 * wyleczono / liczbaTestow).ToString() + "% pacjentów.\n\r");
            }
             
            
            return wynik.ToString();
        }
    }
}
