﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using SymulatorZielarza_WarstwaBazowa;
using UnityEngine;
using Valve.VR;

namespace SymulatorZielarza_WarstwaWinVR
{
    public class MenedzerWejsciaWinVR : MonoBehaviour, IMenedzerWejscia
    {
        public GameObject KontrolerGracza;

        private event DelegatLogicznejAkcji ZdarzenieLogicznejAkcji;
        private SteamVR_Action_Boolean _akcjaRuszDoPrzodu;      
        private SteamVR_Action_Boolean _akcjaRuszDoTylu;
        private SteamVR_Action_Boolean _akcjaRuszWLewo;
        private SteamVR_Action_Boolean _akcjaRuszWPrawo;
        private SteamVR_Action_Boolean _akcjaInterakcja;
        private SteamVR_Action_Boolean _akcjaSkok;
        private SteamVR_Action_Boolean _akcjaRozwinPlecak;
        private SteamVR_Action_Boolean _akcjaUruchomRzemieslnictwo;
        private SteamVR_Action_Boolean _akcjaPlecakWLewo, _akcjaPlecakWPrawo;
        private SteamVR_Action_Boolean _akcjaCzasWolniej, _akcjaCzasSzybciej;
        private SteamVR_Action_Boolean _akcjaWyrzucPrzedmiot;
        private SteamVR_Action_Boolean _akcjaWyjdzDoMenu;
        private SteamVR_Action_Boolean _akcjaPomoc;

        public void NasluchujWejscie(DelegatLogicznejAkcji sluchacz)
        {
            ZdarzenieLogicznejAkcji += sluchacz;
        }
        public void ZakonczNasluch(DelegatLogicznejAkcji sluchacz)
        {
            ZdarzenieLogicznejAkcji -= sluchacz;
        }

        void Start()
        {
            _akcjaRuszDoPrzodu = SteamVR_Input.GetAction<SteamVR_Action_Boolean>("RuszDoPrzodu");
            _akcjaRuszDoTylu = SteamVR_Input.GetAction<SteamVR_Action_Boolean>("RuszDoTylu");
            _akcjaRuszWPrawo = SteamVR_Input.GetAction<SteamVR_Action_Boolean>("RuszWPrawo");
            _akcjaRuszWLewo = SteamVR_Input.GetAction<SteamVR_Action_Boolean>("RuszWLewo");
            _akcjaInterakcja = SteamVR_Input.GetAction<SteamVR_Action_Boolean>("Interakcja");
            _akcjaSkok = SteamVR_Input.GetAction<SteamVR_Action_Boolean>("Skocz");
            _akcjaRozwinPlecak = SteamVR_Input.GetAction<SteamVR_Action_Boolean>("RozwinPlecak");
            _akcjaUruchomRzemieslnictwo = SteamVR_Input.GetAction<SteamVR_Action_Boolean>("UruchomRzemieslnictwo");
            _akcjaPlecakWLewo = SteamVR_Input.GetAction<SteamVR_Action_Boolean>("PlecakWLewo");
            _akcjaPlecakWPrawo = SteamVR_Input.GetAction<SteamVR_Action_Boolean>("PlecakWPrawo");
            _akcjaCzasWolniej = SteamVR_Input.GetAction<SteamVR_Action_Boolean>("CzasWolniej");
            _akcjaCzasSzybciej = SteamVR_Input.GetAction<SteamVR_Action_Boolean>("CzasSzybciej");
            _akcjaWyrzucPrzedmiot = SteamVR_Input.GetAction<SteamVR_Action_Boolean>("WyrzucPrzedmiot");
            _akcjaWyjdzDoMenu = SteamVR_Input.GetAction<SteamVR_Action_Boolean>("WyjdzDoMenu");
            _akcjaPomoc = SteamVR_Input.GetAction<SteamVR_Action_Boolean>("Pomoc");
        }
        void Update()
        {
            Vector3 swobodnyRuch = Vector3.zero;
            if (_akcjaRuszDoPrzodu.GetLastState(SteamVR_Input_Sources.Any))
            {
                if(KontrolerGracza != null)
                    swobodnyRuch = KontrolerGracza.transform.forward;
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.ZmienPoziomTrudnosci);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            else if (_akcjaRuszDoTylu.GetLastState(SteamVR_Input_Sources.Any))
            {
                if (KontrolerGracza != null)
                    swobodnyRuch = -KontrolerGracza.transform.forward;
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.ZmienPoziomTrudnosci);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            else if (_akcjaRuszWLewo.GetLastState(SteamVR_Input_Sources.Any))
            {
                if (KontrolerGracza != null)
                    swobodnyRuch = KontrolerGracza.transform.right;
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.ZmienPoziomTrudnosci);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            else if (_akcjaRuszWPrawo.GetLastState(SteamVR_Input_Sources.Any))
            {
                if (KontrolerGracza != null)
                    swobodnyRuch = -KontrolerGracza.transform.right;
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.ZmienPoziomTrudnosci);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            if (_akcjaInterakcja.GetLastStateDown(SteamVR_Input_Sources.Any))
            {
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Interakcja);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.KontynuujGre);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            if (_akcjaRozwinPlecak.GetLastStateDown(SteamVR_Input_Sources.Any))
            {
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.RozwinPlecak);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.KontynuujGre);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            if (_akcjaUruchomRzemieslnictwo.GetLastStateDown(SteamVR_Input_Sources.Any))
            {
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.UruchomRzemieslnictwo);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            if (_akcjaPlecakWLewo.GetLastStateDown(SteamVR_Input_Sources.Any))
            {
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.PlecakWLewo);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.ZmienPoziomJakosci);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            if (_akcjaPlecakWPrawo.GetLastStateDown(SteamVR_Input_Sources.Any))
            {
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.PlecakWPrawo);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.ZmienPoziomJakosci);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            if (_akcjaCzasWolniej.GetLastStateDown(SteamVR_Input_Sources.Any))
            {
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.CzasWolniej);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.ZmienPoziomJakosci);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            if (_akcjaCzasSzybciej.GetLastStateDown(SteamVR_Input_Sources.Any))
            {
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.CzasSzybciej);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.ZmienPoziomJakosci);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            if (_akcjaWyrzucPrzedmiot.GetLastStateDown(SteamVR_Input_Sources.Any))
            {
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.WyrzucPrzedmiot);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.NowaGra);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            if (_akcjaSkok.GetLastStateDown(SteamVR_Input_Sources.Any))
            {
                if (KontrolerGracza != null)
                    KontrolerGracza.GetComponent<KontrolerGraczaWinVR>().WykonajSkok();
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.NowaGra);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            if (_akcjaPomoc.GetLastStateDown(SteamVR_Input_Sources.Any))
            {
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Pomoc);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.PrzewodnikDalej);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.ZamknijGre);
            }
            if (_akcjaWyjdzDoMenu.GetLastStateDown(SteamVR_Input_Sources.Any))
            {
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.WyjdzDoMenu);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.ZamknijGre);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            if(KontrolerGracza != null)
                KontrolerGracza.GetComponent<KontrolerGraczaWinVR>().WykonujSwobodnyRuch(swobodnyRuch);
        }
    
    }

}
