﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using System.Collections.Generic;

namespace ZielarzSilnik
{
    //Handlarz przechowuje liste przedmiotow w posiadaniu, co godzine losowo wymienia badz dodaje jakis przedmiot i odswieza zloto
    public class Handlarz : Postac
    {
        public int LiczbaPrzedmiotow { get { return _listaPrzedmiotow.Count; } }
        public bool OdswiezanieSklepu { get; set; }         //okresla czy ma byc wlaczone odswiezanie przedmiotow

        public const int MAKSIMUMPRZEDMIOTOW = 8;      //maks. liczba przedmiotow sprzedawanych
        private const int OPTIMUMZLOTA = 500;            //liczba zlota u handlarza do ktorej dazy
        private const float ROZNICACEN = 0.5f;            //o ile razy mniej gracz dostanie za sprzedaż niż wynosi podstawowa wartość przedmiotu
        private List<string> _listaPrzedmiotow;
        
        public Handlarz() : base()
        {
            _listaPrzedmiotow = new List<string>();
            OdczytajGre();
            OdswiezanieSklepu = true;
            SystemDniaNocyPogody.Instancja.ZmianaGodziny += UplynelaGodzina;
            if (_listaPrzedmiotow.Count == 0)
            {
                DodajLubZamienPrzedmiot("PrzedmiotRecepturaMascSosnowa");
                DodajLubZamienPrzedmiot("PrzedmiotRecepturaNalewkaSosnowa");
                DodajLubZamienPrzedmiot("PrzedmiotSpirytus");
                DodajLubZamienPrzedmiot("PrzedmiotWosk");
                UstawAtrybut("Zloto", OPTIMUMZLOTA);
                OdswiezListePrzedmiotow();
            }           
        }     
        public string PodajKolejnyPrzedmiot(int indeks)
        {
            if (indeks >= 0 && indeks < LiczbaPrzedmiotow)
                return _listaPrzedmiotow[indeks];
            return null;
        }
        public void ZapiszGre()
        {
            MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna( "HandlarzZloto", PobierzAtrybut("Zloto"));
            string przedmiotyStr = "";
            foreach (string pojedynczyPrzedmiot in _listaPrzedmiotow)
                przedmiotyStr +=  pojedynczyPrzedmiot + ";";
            MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("PrzedmiotyHandlarza", przedmiotyStr);
        }

        //za ile sprzedawca moze zdecydowac sie na zakup podanego przedmiotu
        public int ZaIleKupie(Przedmiot przedmiot)
        {
            if (przedmiot.WewnetrzneDane.Wartosc < 2)
                return 1;
            return (int)(przedmiot.WewnetrzneDane.Wartosc * ROZNICACEN);
        }
        //dodaj przedmiot do listy jesli jest miejsce a jeśli nie to zamień z losowo wybranym przedmiotem
        public void DodajLubZamienPrzedmiot(string nazwaPrzedmiotu)
        {
            if (_listaPrzedmiotow.Count >= MAKSIMUMPRZEDMIOTOW)
                SkasujAtrybut("Przedmiot" + _listaPrzedmiotow[UnityEngine.Random.Range(0, _listaPrzedmiotow.Count)]);
            UstawAtrybut("Przedmiot" + nazwaPrzedmiotu, 1);
            OdswiezListePrzedmiotow();
            ZapiszGre();
        }
        //usuń podany przedmiot z listy
        public void UsunPrzedmiot(string nazwaPrzedmiotu)
        {
            for(int i = 0; i < _listaPrzedmiotow.Count; i++ )
                if(_listaPrzedmiotow[i] == nazwaPrzedmiotu)
                    SkasujAtrybut("Przedmiot" + _listaPrzedmiotow[i]);
            OdswiezListePrzedmiotow();
            ZapiszGre();
        }
      
        private void OdswiezListePrzedmiotow()
        {
            _listaPrzedmiotow.Clear();
            foreach (string kluczAtrybutu in _atrybutyPostaci.Keys)
                if (kluczAtrybutu.StartsWith("Przedmiot"))
                    _listaPrzedmiotow.Add(kluczAtrybutu.Replace("Przedmiot", ""));   
        }
        private void UplynelaGodzina(int godzina)
        {
            if (OdswiezanieSklepu)
            {
                float zloto = PobierzAtrybut("Zloto");
                float dodajZlota = 0;
                //zmien złoto w kierunku optymalnego
                if (zloto < OPTIMUMZLOTA * 0.9f)
                    dodajZlota = UnityEngine.Random.Range(OPTIMUMZLOTA * 0.05f, OPTIMUMZLOTA - zloto);
                else if (zloto < OPTIMUMZLOTA)
                    dodajZlota = OPTIMUMZLOTA - zloto;
                if (zloto > OPTIMUMZLOTA * 1.1f)
                    dodajZlota = -UnityEngine.Random.Range(OPTIMUMZLOTA * 0.05f, zloto - OPTIMUMZLOTA);
                else if (zloto > OPTIMUMZLOTA)
                    dodajZlota = OPTIMUMZLOTA - zloto;
                UstawAtrybut("Zloto", (int)(zloto + dodajZlota));
                //wylosuj jakiś nowy przedmiot na sprzedaż
                string losowy = MenedzerZielarstwa.Instancja.WylosujPrzedmiot();
                //i jakiś jest maks przedmiotów to zamien jeden losowo wybrany, a jesli nie maks. to dodaj
                if (losowy != null)
                    DodajLubZamienPrzedmiot(losowy);
                ZapiszGre();
            }
        }
        private void OdczytajGre()
        {
            UstawAtrybut("Zloto", MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaFloat("HandlarzZloto"));
            string przedmiotyStr = MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaString("PrzedmiotyHandlarza");
            string[] listaPrzedmiotow = przedmiotyStr.Split(';');
            foreach (string pojedynczyPrzedmiot in listaPrzedmiotow)
                if (pojedynczyPrzedmiot != "" && !_atrybutyPostaci.ContainsKey("Przedmiot" + pojedynczyPrzedmiot))
                    DodajLubZamienPrzedmiot(pojedynczyPrzedmiot);
            OdswiezListePrzedmiotow();
        }

    }
}
