﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using System;
using UnityEngine;
using UnityEngine.EventSystems;
using UnityEngine.UI;

namespace ZielarzSilnik
{

    public class MenedzerUI : MonoBehaviour
    {
        public static MenedzerUI Instancja { get; private set; }
        public const float ZASIEGDOTKNIECIA = 3.5f;     // maksymalny zasieg do obiektu aby mozna bylo z nim przeprowadzic interakcje
        public const float CZASMALEGOINFO = 3.5f;       // czas wysświetlania się małego komunikatu tekstowego w UI
        public const float DYSTANSPOKAZYWANIAKANWY = 4.5f;  // dystans pokazywania dynamicznych kanw dialogow [m.]
        public Sprite WskaznikWlaczony, WskaznikWylaczony;
        public Canvas KanwaOpisu, KanwaMalegoInfo;
        public Canvas KanwaRzemiosla;
        public Text TekstZlota;

        private Text[] _tekstyOpisuPrzedmiotu;
        private Text[] _tekstyMalegoInfo;
        private SpriteRenderer _wskaznikKamery;        
        private GameObject _poprzednioPatrzylismy;
        private float _licznikCzasuMalegoInfo;

        private void Awake()
        {
            if (Instancja != null && Instancja != this)
                throw new Exception("Niedozwolone tworzenie kolejnej kopii klasy MenedzerUI");
            Instancja = this;
         }

        void Start()
        {
            _wskaznikKamery = MenedzerGry.InstancjaMenedzeraGry.KontrolerGracza.GetComponentInChildren<SpriteRenderer>();           
            _poprzednioPatrzylismy = gameObject; //patrzy tu sam na siebie, tym trickiem wymuszamy zmiane w pierwszym Update
            if (KanwaMalegoInfo == null)
                Debug.LogError("Kawna małego info nie jest ustawiona!");
            if (KanwaOpisu == null)
                Debug.LogError("Kawna opisu przedmiotu nie jest ustawiona!");
            if (KanwaRzemiosla == null)
                Debug.LogError("Kawna rzemiosła nie jest ustawiona!");
            if (TekstZlota == null )
                Debug.LogError("Tekst ilośc złota nie jest ustawiony!");

            _tekstyMalegoInfo = KanwaMalegoInfo.GetComponentsInChildren<Text>();
            _tekstyOpisuPrzedmiotu = KanwaOpisu.GetComponentsInChildren<Text>();
            KanwaMalegoInfo.gameObject.SetActive(false);
            KanwaOpisu.gameObject.SetActive(false);
            KanwaRzemiosla.gameObject.SetActive(false);
            TekstZlota.transform.position = Camera.main.ScreenToWorldPoint(new Vector3(5, Screen.height - 5, 0.35f));
            //t.gameObject.GetComponent<RectTransform>().anchoredPosition3D = Camera.main.ScreenToWorldPoint(new Vector3(0, Screen.height - 5, 0.35f));

            _licznikCzasuMalegoInfo = 0;
        }

        void Update()
        {
            GameObject patrzymy = NaCoPatrzyKamera();
            if (_poprzednioPatrzylismy != patrzymy)
            {
                if (patrzymy != null && patrzymy.GetComponent<AktywnyObiekt>() != null)
                {
                    _wskaznikKamery.sprite = WskaznikWlaczony;
                    foreach(Text t in _tekstyOpisuPrzedmiotu)
                        t.text = patrzymy.GetComponent<AktywnyObiekt>().CzytelnaNazwa;
                    KanwaOpisu.gameObject.SetActive(true);
                }
                else
                {
                    _wskaznikKamery.sprite = WskaznikWylaczony;
                    KanwaOpisu.gameObject.SetActive(false);
                }
            }           
            if (patrzymy != null && patrzymy.GetComponent<Button>() != null)
                patrzymy.GetComponent<Button>().Select();
            else if(_poprzednioPatrzylismy != null && _poprzednioPatrzylismy.GetComponent<Button>() != null)
                EventSystem.current.SetSelectedGameObject(null);
            _poprzednioPatrzylismy = patrzymy;
            TekstZlota.text = TlumaczCiagow.PodajCiag("Zloto") + ((int) MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.PobierzAtrybut("Zloto")).ToString();
            ReagujNaWejscie(patrzymy);
        }
        
        public GameObject NaCoPatrzyKamera()
        {
            RaycastHit hit;
            Vector3 punktCentralny = Camera.main.ScreenToWorldPoint(new Vector3(Screen.width / 2, Screen.height / 2, 0.1f));
            if (Physics.Raycast(punktCentralny, Camera.main.transform.forward, out hit))
                if (hit.distance < ZASIEGDOTKNIECIA)
                    return hit.collider.gameObject;
            return null;

        }

        public void PokazMaleInfo(string tekst)
        {
            foreach (Text t in _tekstyMalegoInfo)
                t.text = tekst;
            KanwaMalegoInfo.gameObject.SetActive(true);
            _licznikCzasuMalegoInfo = CZASMALEGOINFO;
        }

        private void ReagujNaWejscie(GameObject patrzymy)
        {
#if UNITY_EDITOR
            if (Input.GetKeyDown(KeyCode.F1))
                Debug.Log(MenedzerGry.InstancjaMenedzeraGry.WykonajMasowyTestChorob(100));
#endif
            if (Input.GetKeyDown(KeyCode.F5))
                MenedzerGry.InstancjaMenedzeraGry.ZapiszGre();
            if (Input.GetKeyDown(KeyCode.P))
                MenedzerGry.InstancjaMenedzeraGry.ObiektPlecaka.Rozszerzony = !MenedzerGry.InstancjaMenedzeraGry.ObiektPlecaka.Rozszerzony;
            if (Input.GetKeyDown(KeyCode.LeftBracket))
                MenedzerGry.InstancjaMenedzeraGry.ObiektPlecaka.PrzesunWybranyPanel(-1);
            if (Input.GetKeyDown(KeyCode.RightBracket))
                MenedzerGry.InstancjaMenedzeraGry.ObiektPlecaka.PrzesunWybranyPanel(1);
            if (Input.GetKeyDown(KeyCode.E))
            {
                if (patrzymy != null)
                {
                    if (patrzymy.GetComponent<Przedmiot>() != null)
                        patrzymy.GetComponent<Przedmiot>().DodajDoPlecaka();
                    else if (patrzymy.transform.parent != null && patrzymy.transform.parent.GetComponent<KomponentPacjent>() != null)
                    {
                        Przedmiot aktywny = MenedzerGry.InstancjaMenedzeraGry.ObiektPlecaka.AktywnyPrzedmiot;
                        bool przyjetoPrzedmiot = patrzymy.transform.parent.GetComponent<KomponentPacjent>().DodajPrzedmiotLeczacy(aktywny);
                        if (przyjetoPrzedmiot)
                            MenedzerGry.InstancjaMenedzeraGry.ObiektPlecaka.ZniszczPoCichuPrzedmiot(MenedzerGry.InstancjaMenedzeraGry.ObiektPlecaka.AktywnyPrzedmiot);
                    }
                    else if (patrzymy.GetComponent<UIHandlu>() != null)
                        patrzymy.GetComponent<UIHandlu>().Uaktywnij();
                    else if (patrzymy.GetComponent<UIInformacyjne>() != null)
                        patrzymy.GetComponent<UIInformacyjne>().Uaktywnij();

                    else
                        if (patrzymy.GetComponent<Button>() != null)
                        patrzymy.GetComponent<Button>().onClick.Invoke();
                }
            }
            if (Input.GetMouseButtonDown(0))
                if (patrzymy != null && patrzymy.GetComponent<Button>() != null)
                    patrzymy.GetComponent<Button>().onClick.Invoke();
            if (_licznikCzasuMalegoInfo >= 0)
            {
                _licznikCzasuMalegoInfo -= Time.deltaTime;
                if (_licznikCzasuMalegoInfo <= 0)
                    KanwaMalegoInfo.gameObject.SetActive(false);
            }
            if (Input.GetKeyDown(KeyCode.R))
            {
                KanwaRzemiosla.gameObject.SetActive(!KanwaRzemiosla.gameObject.activeInHierarchy);
                //przesun kanwe rzemiosla przed gracza (obroci sie sama bo ma AutoObracacz)
                Vector3 nowaPozycja = MenedzerGry.InstancjaMenedzeraGry.KontrolerGracza.transform.position + MenedzerGry.InstancjaMenedzeraGry.KontrolerGracza.transform.forward * 2f;
                KanwaRzemiosla.transform.position = new Vector3(nowaPozycja.x, nowaPozycja.y, nowaPozycja.z);
            }
        }
    }
}