﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using UnityEngine;
namespace ZielarzSilnik
{

    public class Przedmiot : MonoBehaviour
    {
        public string Nazwa
        {
            get
            {
                if (_komponentAO != null)
                    return _komponentAO.Nazwa;
                else
                    return "?";
            }
        }
        public Vector3 PrzesuniecieWPlecaku = Vector3.zero;
        public Vector3 RotacjaWPlecaku = Vector3.zero;        //w mierze kątowej (Euler angles)
        public Vector3 SkalaWPlecaku = new Vector3(0.2f, 0.2f, 0.2f);
        public PrzedmiotLeczniczy WewnetrznyPrzedmiotLeczniczy
        {
            get;  private set;
        }

        private AktywnyObiekt _komponentAO;
        private Vector3 _oryginalnaSkala;

        public void PrzygotujNaPlecak()
        {
            _oryginalnaSkala = transform.localScale;
            if (GetComponent<Rigidbody>() != null)
                Destroy(GetComponent<Rigidbody>());
            if (GetComponent<Collider>() != null)
                GetComponent<Collider>().enabled = false;
        }
        public void DodajDoPlecaka()
        {
            PrzygotujNaPlecak();
            gameObject.AddComponent<EfektPodnoszenia>();
        }
        public void FinalizujDodanieDoPlecaka()
        {
            Destroy(GetComponent<EfektPodnoszenia>());
            MenedzerGry.InstancjaMenedzeraGry.ObiektPlecaka.Dodaj(this);
        }
        public void UsunZPlecaka()
        {
            if (GetComponent<Collider>() != null)
                GetComponent<Collider>().enabled = true;
            if (GetComponent<Rigidbody>() == null)
            {
                gameObject.AddComponent<Rigidbody>();
                GetComponent<Rigidbody>().mass = 1;
            }
            transform.localScale = _oryginalnaSkala;
            transform.parent = MenedzerGry.InstancjaMenedzeraGry.transform;
            transform.position = Camera.main.transform.position + Camera.main.transform.forward;
            GetComponent<Rigidbody>().AddForce(Camera.main.transform.forward *150);
        }

        private void Start()
        {
            _komponentAO = GetComponent<AktywnyObiekt>();
            WewnetrznyPrzedmiotLeczniczy = MenedzerZielarstwa.Instancja.UtworzPrzedmiotLeczniczy(_komponentAO.Typ);
        }

    }

}