﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using System.Globalization;
using System;
using System.Xml.Linq;
using UnityEngine;

namespace ZielarzSilnik
{

    //informacja o tym jak mocne jest leczenie konkretnego zdarzenia przez substancje lecznicza
    public class LeczenieZdarzenia
    {
        public string TypZdarzenia;                     // jakie zdarzenie
        public CzescCiala GdzieLeczy;                   // w jakich lokalizacjach jest w stanie leczyc zdarzenie
        public float Leczenie;                          // sredni spadek sily zdarzenia na godzine, UWAGA: wartosc ujemna jest mozliwa i oznacza substancje szkodzaca a nie leczaca
        public float WartoscGraniczna;                  // minimalna liczba jednostek bazowych substancji leczniczej od ktorej aktywuje sie leczenie/zatrucie
        public SposobPodania DopuszczalnySposobPodania; // sposob podania substancji leczniczej wymagany do aktywacji leczenia/zatrucia

        //konstruktor dla tworzenia struktury ktorej dane beda ladowane z wezla XML
        public LeczenieZdarzenia(XElement elementXMLDanych)
        {
            if (elementXMLDanych.Attribute("typZdarzenia") == null)
                Debug.LogError("Brak atrybutu typZdarzenia w elemencie danych " + elementXMLDanych.ToString());
            else TypZdarzenia = elementXMLDanych.Attribute("typZdarzenia").Value;

            if (elementXMLDanych.Attribute("gdzieLeczy") == null)
                Debug.LogError("Brak atrybutu gdzieLeczy w elemencie danych " + elementXMLDanych.ToString());
            else
                GdzieLeczy = (CzescCiala)Enum.Parse(typeof(CzescCiala), elementXMLDanych.Attribute("gdzieLeczy").Value);

            if (elementXMLDanych.Attribute("leczenie") == null)
                Debug.LogError("Brak atrybutu leczenie w elemencie danych " + elementXMLDanych.ToString());
            else Leczenie = float.Parse(elementXMLDanych.Attribute("leczenie").Value, CultureInfo.InvariantCulture);

            if (elementXMLDanych.Attribute("granica") == null)
                WartoscGraniczna = 1;
            else WartoscGraniczna = float.Parse(elementXMLDanych.Attribute("granica").Value, CultureInfo.InvariantCulture);

            if (elementXMLDanych.Attribute("sposob") == null)
                Debug.LogError("Brak atrybutu sposob w elemencie danych " + elementXMLDanych.ToString());
            else DopuszczalnySposobPodania = (SposobPodania)Enum.Parse(typeof(SposobPodania), elementXMLDanych.Attribute("sposob").Value);

        }

        //konstruktor kopiujacy dane z klona struktury
        public LeczenieZdarzenia(LeczenieZdarzenia klonujZTejStruktury)
        {
            TypZdarzenia = klonujZTejStruktury.TypZdarzenia;
            GdzieLeczy = klonujZTejStruktury.GdzieLeczy;
            Leczenie = klonujZTejStruktury.Leczenie;
            WartoscGraniczna = klonujZTejStruktury.WartoscGraniczna;
            DopuszczalnySposobPodania = klonujZTejStruktury.DopuszczalnySposobPodania;
        }

    }

   
}
