﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using System;
using System.Collections.Generic;
using System.Text;
using UnityEngine;

namespace ZielarzSilnik
{

    public class MenedzerGry: MonoBehaviour
    {
        public static MenedzerGry InstancjaMenedzeraGry { get; private set; }

        public GameObject[] PunktyPacjentowStacjonarnych;
        public GameObject KontrolerGracza;

        private bool _PierwszyUpdate;
        private GameObject _SzablonPacjenta;

        private void Awake()
        {
            if (InstancjaMenedzeraGry != null && InstancjaMenedzeraGry != this)
                throw new Exception("Niedozwolone tworzenie kolejnej kopii klasy MenedzerGry");

            InstancjaMenedzeraGry = this;
            _PierwszyUpdate = true;

            _SzablonPacjenta = null;
        }


        private void Update()
        {
            if(_PierwszyUpdate)
            {
               SystemDniaNocyPogody.Instancja.ZmianaGodziny += UplynelaGodzina;
               MenedzerZielarstwa.Instancja.ZaladujDane();
                _PierwszyUpdate = false;
            }

        }

        private void UplynelaGodzina(int godzina)
        {
            foreach(GameObject punktpacjenta in PunktyPacjentowStacjonarnych)
                if(punktpacjenta.transform.childCount == 0 && UnityEngine.Random.Range(0, 2) == 0)
                {
                    UtworzPacjenta(punktpacjenta);
                }
        }

        private void UtworzPacjenta(GameObject PunktTworzenia)
        {
            if (_SzablonPacjenta == null)
                _SzablonPacjenta = Resources.Load<GameObject>("Prefaby/Pacjent");
            if (_SzablonPacjenta == null)
                Debug.LogError("Nie udało się załadować szablonu pacjenta z zasobów.");
            else
            {
                GameObject nowyPacjent = Instantiate(_SzablonPacjenta, Vector3.zero, Quaternion.identity, PunktTworzenia.transform);
                nowyPacjent.transform.localPosition = Vector3.zero;
                nowyPacjent.GetComponent<KomponentPacjent>().WylosujChoroby();
            }
        }

        public string WykonajMasowyTestChorob(int liczba)
        {
            StringBuilder wynik = new StringBuilder();
            Dictionary<string, int> przyczynyZgonow = new Dictionary<string, int>();

            int wyleczono = 0;
            int zmarlBezPrzyczyny = 0;
            for (int i = 0; i < liczba; i++)
            {
                Pacjent pacjent = new Pacjent();
                pacjent.WylosujChoroby();
                while (!pacjent.JestZdrowy && pacjent.JestZywy)
                {
                    pacjent.GodzinowaObslugaZdarzen();
                }
                if (pacjent.JestZdrowy)
                    wyleczono++;
                else if (pacjent.PrzyczynaZgonu == "")
                    zmarlBezPrzyczyny++;
                else
                {
                    if (przyczynyZgonow.ContainsKey(pacjent.PrzyczynaZgonu))
                        przyczynyZgonow[pacjent.PrzyczynaZgonu]++;
                    else
                        przyczynyZgonow.Add(pacjent.PrzyczynaZgonu, 1);
                }
            }
            foreach(string przyczyna in przyczynyZgonow.Keys)
                wynik.Append("Zmarło z powodu " + przyczyna +": " + (100 * przyczynyZgonow[przyczyna] / liczba).ToString() + "% pacjentów. \n\r");
            wynik.Append("Zmarło z wycieńczenia: " + (100 * zmarlBezPrzyczyny / liczba).ToString() + "% pacjentów.\n\r");
            wynik.Append("Wyleczono: " + (100 * wyleczono / liczba).ToString() + "% pacjentów.\n\r");
            return wynik.ToString();
        }

    }


}
