function createAndCompileModel(
	layers, hiddenSize, rnnType, digits, vocabularySize) {
	const maxLen = digits + 1 + digits;
	const model = tf.sequential();
	model.add(tf.layers.simpleRNN({
		units: hiddenSize,
		recurrentInitializer: 'glorotNormal',
		inputShape: [maxLen, vocabularySize]
	}));
	model.add(tf.layers.repeatVector({ n: digits + 1 }));
	model.add(tf.layers.simpleRNN({
		units: hiddenSize,
		recurrentInitializer: 'glorotNormal',
		returnSequences: true
	}));
	model.add(tf.layers.timeDistributed(
		{ layer: tf.layers.dense({ units: vocabularySize }) }));
	model.add(tf.layers.activation({ activation: 'softmax' }));
	model.compile({
		loss: 'categoricalCrossentropy',
		optimizer: 'adam',
		metrics: ['accuracy']
	});
	return model;
}