Notatniki uczenia maszynowego, wydanie 3.
==========================

Celem tego projektu jest nauczenie Cię podstaw uczenia maszynowego w środowisku Python. Znajdziesz tu przykładowy kod i rozwiązania ćwiczeń wyznaczonych w książce [Hands-on Machine Learning with Scikit-Learn, Keras and TensorFlow (3rd edition)](https://homl.info/er3):

<a href="https://homl.info/er3"><img src="https://learning.oreilly.com/library/cover/9781098125967/300w/" title="book" width="150" border="0" /></a>

**Uwaga** Jeśli interesują Cię notatniki z wydania drugiego, znajdziesz je w repozytorium [ageron/handson-ml2](https://github.com/ageron/handson-ml2). Z kolei pliki dla pierwszego wydania dostępne są w repozytorium [ageron/handson-ml](https://github.com/ageron/handson-ml).

## Szybki start

### Chcesz pobawić sie tymi notatnikami w internecie bez konieczności instalowania czegokolwiek?

* <a href="https://colab.research.google.com/github/ageron/handson-ml3/blob/main/" target="_parent"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Otwórz w środowisku Colab"/></a> (zalecane)

⚠ _Colab zawiera środowisko tymczasowe: wszystko, co tam zrobisz, zostaniesz po jakimś czasie usunięte, dlatego pobieraj wszelkie potrzebne Ci stamtąd dane._

<details>

Inne usługi również mogą działać dobrze, ale nie przetestowałem ich w pełni:

* <a href="https://homl.info/kaggle3/"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Otwórz w środowisku Kaggle" /></a>

* <a href="https://mybinder.org/v2/gh/ageron/handson-ml3/HEAD?filepath=%2Findex.ipynb"><img src="https://mybinder.org/badge_logo.svg" alt="Uruchom binder" /></a>

* <a href="https://homl.info/deepnote3/"><img src="https://deepnote.com/buttons/launch-in-deepnote-small.svg" alt="Uruchom w środowisku Deepnote" /></a>

</details>

### Chcesz na szybko przejrzeć niektóre notatniki bez wykonywania kodu?

* <a href="https://nbviewer.jupyter.org/github/ageron/handson-ml3/blob/main/index.ipynb"><img src="https://raw.githubusercontent.com/jupyter/design/master/logos/Badges/nbviewer_badge.svg" alt="Wyświetl nbviewer" /></a>

* [Przeglądarka notatników w serwisie github.com](https://github.com/ageron/handson-ml3/blob/main/index.ipynb) również działa, ale nie jest idealna: jest wolniejsza, równania matematyczne nie zawsze są właściwie wyświetlane, a dużych notatników czasem wcale nie da się otworzyć.

### Chcesz uruchomić ten projekt za pomocą obrazu Dockera?
Zapoznaj się [instrukcjami dotyczącymi Dockera](https://github.com/ageron/handson-ml3/tree/main/docker).

### Chcesz zainstalować ten projekct na swoim komputerze?

Zainstaluj najpierw [Anacondę](https://www.anaconda.com/products/distribution) (lub [Minicondę](https://docs.conda.io/en/latest/miniconda.html)), [git](https://git-scm.com/downloads) i, jeśli dysponujesz kartą graficzną obsługującą procesor GPU, również [sterownik GPU](https://www.nvidia.com/Download/index.aspx), jak również odpowiednią wersję bibliotek CUDA oraz cuDNN (szczegóły znajdziesz w dokumentacji biblioteki TensorFlow).

Następnie sklonuje ten projekt otwierając terminal i wpisując poniższe polecenia (pomiń symbol `$` w poszczególnych wierszach, gdyż określa on tylko, że mamy do czynienia z poleceniami terminala):

    $ git clone https://github.com/ageron/handson-ml3.git
    $ cd handson-ml3

Następnie wpisz poniższe polecenia:

    $ conda env create -f environment.yml
    $ conda activate homl3
    $ python -m ipykernel install --user --name=python3

Na koniec uruchom środowisko Jupyter:

    $ jupyter notebook

Szczegółowe informacje znajdziesz [w instrukcjach instalacji](INSTALL.md).

# FAQ

**Z której wersji Pythona powinienem korzystać?**

Polecam Pythona 3.10. Jeżeli postępujesz zgodnie z powyższymi instrukcjami, to zostanie zainstalowana właśnie ta wersja. Każda wersja ≥3.7 będzie odpowiednia.

**Wyskakuje mi błąd podczas wywoływania funkcji `load_housing_data()`**

Jeżeli jest to błąd HTTP, sprawdź, czy korzystasz z tego samego kodu, który znajduje się w notatniku (w razie potrzeby skopiuj i wklej go). Jeżeli problem nie znika, sprawdź swoją konfigurację sieciową. Jeśli jest to błąd SSL, przejdź do następnego pytania.

**Wyskakuje mi błąd SSL w systemie MacOSX**

Prawdopodobnie musisz zainstalowac certyfikaty SSL (zob. to [pytanie StackOverflow](https://stackoverflow.com/questions/27835619/urllib-and-ssl-certificate-verify-failed-error)). Jeżeli pobrałeś Pythona z oficjalnej strony, to wpisz polecenie `/Applications/Python\ 3.10/Install\ Certificates.command` w terminalu (zmień `3.10` na zainstalowaną wersję). Jeżeli zainstalowałeś Pythona za pomocą MacPorts, wpisz `sudo port install curl-ca-bundle` w terminalu.

**Zainstalowałem projekt lokalnie. Jak mogę zaktualizować do najnowszej wersji?**

Zajrzyj do pliku [INSTALL.md](INSTALL.md).

**Jak mogę zaktualizować biblioteki Pythona do najnowszych wersji, gdy korzystam z Anacondy?**

Zajrzyj do pliku [INSTALL.md](INSTALL.md).

# Ofiarodawcy
Chciałbym podziękować wszystkich osobom [przyczyniającym się do powstania tego projektu](https://github.com/ageron/handson-ml3/graphs/contributors), czy to poprzez sugestie, wykrywanie błędów albo dzielenie się wątpliwościami. Specjalne podziękowania kieruję do użytkowników Haesuna Parka i Iana Beauregarda, którzy przejrzeli każdy notatnik i wysłali mi mnóstwo sugestii, w tym pomoc w rozwiązaniu niektórych ćwiczeń. Dziękuję również Stevenowi Bunkley`owi i Ziembli za stworzenie katalogu `docker`, a także użytkownikowi githuba SuperYorio za pomoc w niektórych ćwiczeniach. Wielkie dzięki dla Victora Khaustova, który wysłał wiele znakomitych wiadomości pozwalających usunąć mnóstwo błędów. Na koniec dziękuję zespołowi Google ML Developer Programs, którzy wspierali tę pracę zapewniając kredyty Google Cloud.
