import { SportsProduct, SPORT } from "./product";
import { Cart } from "./cart";
import { sizeFormatter, costFormatter, writeMessage } from "./tsFormatters";
import debug from "debug";
import chalk from "chalk";

let kayak = new SportsProduct(1, "Kajak", 275, SPORT.Watersports);
let hat =  new SportsProduct(2, "Czapka", 22.10, SPORT.Running, SPORT.Watersports);
let ball = new SportsProduct(3, "Piłka", 19.50, SPORT.Soccer);

let cart = new Cart("Bartek");
cart.addProduct(kayak, 1);
cart.addProduct(hat, 1);
cart.addProduct(hat, 2);

sizeFormatter("Cart", cart.itemCount);
costFormatter("Cart", `${cart.totalPrice}`);

console.log(chalk.greenBright("Sformatowany komunikat"));
//console.log(chalk.notAColor("Sformatowany komunikat"));
