import calcTaxAndSum, { calculateTax } from "./tax";
import { printDetails, applyDiscount } from "./utils";

class Product {
    constructor(name, price) {
        this.id = Symbol();
        this.name = name;
        this.price = price;
    }
}

let product = new Product("czapka", 100);
applyDiscount(product, 10);
let taxedPrice = calculateTax(product.price);
printDetails(product);
let products = [new Product("rękawiczki", 23), new Product("buty", 100)];
let totalPrice = calcTaxAndSum(...products.map(p => p.price));
console.log(`cena całkowita: ${totalPrice.toFixed(2)}`);