import { City, Person, Product, Employee} from "./dataTypes";

function makeObject<T extends new (...args: any) => any>
        (constructor: T, ...args: ConstructorParameters<T>) : InstanceType<T> {
    return  new constructor(...args as any[]);
}

let prod: Product = makeObject(Product, "Kajak", 275);
let city: City = makeObject(City, "Londyn", 8136000);

[prod, city].forEach(item => console.log(`Nazwa: ${item.name}`));